/******************************************************************************
;  *   	@ͺ	   	   	   	  : MC30P6201
;  *   	@             : 2021.08.04
;  *   	@˾/ 	   	   	  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	   	   	   	  CMP EVDʹ
                ͬˣVIR 0.5V
                ˣѹ EVN1(P03)   ΪVDDɼVDDѹ
                ѹ3.0V
                EVN1<3V  P21=1;P01=1
                EVN1>3V  P21=0;P01=0
                ʹʱעȽ ڲοѹѹ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR = 0; FSR < 0xDF; FSR++)
    {
        INDF = 0x00;
    }
    FSR = 0x5F;
    INDF = 0x00;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IOʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    P0 = 0x00;
    P1 = 0x00;
    P2 = 0x00;
    DDR0 = DEF_SET_BIT3; //1:input 0:output  p03in 
    DDR1 = 0x00;
    DDR2 = 0x00;

    PUCON1 = 0xff; //0:Effective 1:invalid
    PDCONL = 0xff; //0:Effective 1:invalid
    ODCON = 0x00;  //0: 1:©

    RBS_1;
    PUCON0 = 0xff; //0:Effective 1:invalid
    PDCONH = 0xff; //0:Effective 1:invalid

    PMOD = 0xCf; //P04-P07 P20 P21  0:̬  1:̬

    P0ADCR = 0x08; //0:ʹֹ 1:رֹ
    RBS_0;
}
/************************************************
;  *    @Function Name       : CMP_EVD_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 :
;  *    @Return parameter    :
;  ***********************************************/
void CMP_EVD_Init(void)
{
   	CMPCR0&=~(DEF_SET_BIT3|DEF_SET_BIT4|DEF_SET_BIT5); //VIR  ѹ
    CMPCR0|=  DEF_SET_BIT2|DEF_SET_BIT6;  //ʹCMP IO  л
    CMPCR1 = 0xA3;      //EVN1 3.0V
   	CMPEN = 1; 	   	   	//ʹܱȽ
    for(temp=0;temp<200;temp++)
    {
        Nop();
        Nop();
        Nop();
        Nop();
    }
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 :  
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    CMP_EVD_Init();
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    while (1)
    {
   	   	if(CMPOF==1)        //ѹ3V
        {
            P21D=1;
        }else
        {
            P21D=0;
        }
    }
}
/************************************************
;  *    @Function Name       : Interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter          	 :
;  *    @Return parameter      	:
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _STATUS
    movra _statusbuf
__endasm;

__asm 
    swapar _statusbuf
    movra _STATUS
    swapr _abuf
    swapar _abuf
__endasm;

}

/**************************** end of file *********************************************/
