/******************************************************************************
;  *   	@ͺ				  : MC30P6201
;  *   	@             : 2021.08.04
;  *   	@˾/			  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	   	   	   	INT ⲿж
                INT0(P10)   Ϊ½شжϷP20ת
                INT1(P00)   Ϊ½شжϷP21ת
******************************************************************************/

#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR = 0; FSR < 0xDF; FSR++)
    {
        INDF = 0x00;
    }
    FSR = 0x5F;
    INDF = 0x00;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IOʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    P0 = 0x00;
    P1 = 0x00;
    P2 = 0x00;
    DDR0 = DEF_SET_BIT0; //1:input 0:output     P00in
    DDR1 = DEF_SET_BIT0;        //P10 in
    DDR2 = 0x00;

    PUCON1 = 0xfE; //0:Effective 1:invalid  P10up
    PDCONL = 0xff; //0:Effective 1:invalid
    ODCON = 0x00;  //0: 1:©

    RBS_1;
    PUCON0 = DEF_CLR_BIT0; //0:Effective 1:invalid  P00up
    PDCONH = 0xff; //0:Effective 1:invalid

    PMOD = 0xCf; //P04-P07 P20 P21  0:̬  1:̬

    P0ADCR = 0x00; //0:ʹֹ 1:رֹ
    RBS_0;
}
/************************************************
;  *    @Function Name       : INT01_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 :
;  *    @Return parameter    :
;  ***********************************************/
void INT01_Init(void)
{
    INT1M=0;
    INT0M=0;        //0 ½ش  1ش
   	
   	EIS=1; 	   	//INT0Ч	
   	INT0IF=0;   //ⲿжϱ־λ
   	INT1IF=0;
   	
    INT1IE=1;          //ʹⲿж
    INT0IE=1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 :  
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    INT01_Init();
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    while (1)
    {

    }
}
/************************************************
;  *    @Function Name       : Interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter          	 :
;  *    @Return parameter      	:
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _STATUS
    movra _statusbuf
__endasm;

    if((INT0IE)&&(INT0IF))
    {
        INT0IF=0;
        P20D=!P20D;
    }
    if((INT1IE)&&(INT1IF))
    {
        INT1IF=0;
        P21D=!P21D;
    }

__asm 
    swapar _statusbuf
    movra _STATUS
    swapr _abuf
    swapar _abuf
__endasm;

}

/**************************** end of file *********************************************/
