/******************************************************************************
;  *   	@ͺ				  : MC30P6201
;  *   	@             : 2021.08.04
;  *   	@˾/			  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	   	   	   	     ʱ0(ⲿ32768)
                    ߣ2S
******************************************************************************/

#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR = 0; FSR < 0xDF; FSR++)
    {
        INDF = 0x00;
    }
    FSR = 0x5F;
    INDF = 0x00;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IOʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    P0 = 0x00;
    P1 = 0x00;
    P2 = 0x00;
    DDR0 = 0x00; //1:input 0:output
    DDR1 = 0x00;
    DDR2 = 0x00;

    PUCON1 = 0xff; //0:Effective 1:invalid
    PDCONL = 0xff; //0:Effective 1:invalid
    ODCON = 0x00;  //0: 1:©

    RBS_1;
    PUCON0 = 0xff; //0:Effective 1:invalid
    PDCONH = 0xff; //0:Effective 1:invalid

    PMOD = 0xCf; //P04-P07 P20 P21  0:̬  1:̬

    P0ADCR = 0x00; //0:ʹֹ 1:رֹ
    RBS_0;
}
/************************************************
;  *    @Function Name       : TIMER0_INT_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 :
;  *    @Return parameter    :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = 0x47;       //ʱΪFLOSC    ʱ256Ƶ
    //T0CNT = 256 - 256; //2S
    T0IE = 1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 :  
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    while (1)
    {
        P20D = 0;
        GIE = 0; //رж  ѺҪж
        Nop();
        Nop();
        Stop();
        Nop();
        Nop();
   	   	T0IF = 0;  	//־
        GIE = 1; //ʹж
        P20D = 1;
    }
}
/************************************************
;  *    @Function Name       : Interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter          	 :
;  *    @Return parameter      	:
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm
        movra _abuf
        swapar _STATUS
        movra _statusbuf
    __endasm;

    if (T0IE && T0IF)
    {
        T0IF = 0;
    }
    __asm
        swapar _statusbuf
        movra _STATUS
        swapr _abuf
        swapar _abuf
    __endasm;
}

/**************************** end of file *********************************************/
