/******************************************************************************
;  *   	@ͺ				  : MC30P6201
;  *   	@             : 2021.08.04
;  *   	@˾/			  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	   	   	   	    KBIM ж
                P00KE(P10)  Ϊʹܼж
                P10KE(P00)  Ϊʹܼж
                ʱ0  ʱ5SжϣP10P00жϻѣʱP20ת
******************************************************************************/

#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR = 0; FSR < 0xDF; FSR++)
    {
        INDF = 0x00;
    }
    FSR = 0x5F;
    INDF = 0x00;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IOʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    P0 = 0x00;
    P1 = 0x00;
    P2 = 0x00;
    DDR0 = DEF_SET_BIT0; //1:input 0:output     P00in
    DDR1 = DEF_SET_BIT0; //P10 in
    DDR2 = 0x00;

    PUCON1 = DEF_CLR_BIT0; //0:Effective 1:invalid  P10up
    PDCONL = 0xff; //0:Effective 1:invalid
    ODCON = 0x00;  //0: 1:©

    RBS_1;
    PUCON0 = 0xfE; //0:Effective 1:invalid  P00up
    PDCONH = 0xff; //0:Effective 1:invalid

    PMOD = 0xCf; //P04-P07 P20 P21  0:̬  1:̬

    P0ADCR = 0x00; //0:ʹֹ 1:رֹ
    RBS_0;
}
/************************************************
;  *    @Function Name       : KBIE_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void KBIE_Init(void)
{
   	EIS = 0;
   	RBS_1;
    P0KBCR = DEF_SET_BIT0; //P00ж
    P1KBCR = DEF_SET_BIT0; //P10ж
   	RBS_0;
}
/************************************************
;  *    @Function Name       : TIMER0_INT_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 :
;  *    @Return parameter    :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = 0x05; //ʱΪCPUʱ    ʱ64Ƶ  1ms
    T0CNT = 256 - 125;
    T0IE = 1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 :  
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    KBIE_Init();
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    while (1)
    {
        if (FLAG_TIMER0_5000ms) //5sһ
        {
            FLAG_TIMER0_5000ms = 0;
   	   	   	P20D = 0;
            GIE = 0;  //رж  ѺҪж
            KBIF = 0; //ⲿжϱ־
            KBIE = 1; //ʹⲿж
            Nop();
            Nop();
            Stop();
            Nop();
            Nop();
            KBIE = 0; //رⲿж
            KBIF = 0; //ⲿж
            GIE = 1;  //ʹж
        }
        P20D = !P20D;
    }
}
/************************************************
;  *    @Function Name       : Interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter          	 :
;  *    @Return parameter      	:
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm
        movra _abuf
        swapar _STATUS
        movra _statusbuf
    __endasm;

    if (T0IE && T0IF)
    {
        T0CNT = 256 - 125;
        T0IF = 0;
        timer0_conut1++;
        if (timer0_conut1 >= 5000)      //ʱ5S
        {
            timer0_conut1 = 0;
            FLAG_TIMER0_5000ms = 1;
        }
    }

    __asm
        swapar _statusbuf
        movra _STATUS
        swapr _abuf
        swapar _abuf
    __endasm;
}

/**************************** end of file *********************************************/
