#include "UART.h"

/************************************************
;  *    @Function Name       : UART_Config
;  *    @Description         :   IO
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/  
void UART_Config(void)
{
   	IOP1|=0x02;
   	OEP1|=0x02;    	   	//P11out
   	PUP1|=0x01;    	   	 //P10
   	
   	T2CR=0x80; 	   	//FCPU   Ƶ
   	T2LOADH=0x00;
   	T2LOADL=51;	   	   	//Baud=FT2/(16*(T2LOAD+1))  4800
   	
   	SCON=0x54; 	   	   	   	//ʽ1  
   	GIE=1;
   	UARTIE=1;
}
/************************************************
;  *    @Function Name       : SendData
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/  
void SendData(u8 dat)
{
    while (UART_Busy);               //ȴǰݷ
    UART_Busy = 1;
    SBUF = dat;                 //дݵUARTݼĴ
}
/************************************************
;  *    @Function Name       : Uart_Send_Data
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void Uart_Send_Data(char *s, uchar len)
{
   	while (len)
   	{
   	   	SendData(*s++);
   	   	len--;
   	}
}
/************************************************
;  *    @Function Name       : SendString
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/  
void SendString(char *s)
{
    while (*s)              //Check the end of the string
    {
        SendData(*s++);     //Send current char and increment string ptr
    }
}