/******************************************************************************
;  *       @ͺ                 : MC32F7062
;  *       @             : 2021.04.13
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : ΢ Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                       ADC 
                ϵȴADȶУ׼Ƶ16M
                Fadc=1M12λH8L4Vref=2V15ADCLK
                T0ʱ2mSɼAN0(P20)ѹ                                     
******************************************************************************/

#include "user.h"
/************************************************
;  *    @            : Delay
;  *    @˵              : ȷʱ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Delay(uint16_t num)
{
    for (g_len = 0; g_len < num; g_len++)
    {
        Nop();
    }
}
/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;

    OEP0 = 0xff; //P0  out
    OEP1 = 0xff; //P1  out
    OEP2 = 0xfe; // P20 in

    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;

    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;

    P2ADCR = DEF_SET_BIT0; //P20رֶ˿ڣʹģ˿
}
/************************************************
;  *    @            : ADC_Power_On_Stability
;  *    @˵              : ADCϵȶ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void ADC_Power_On_Stability(void)
{
    g_cnt = 0;
    ADCR0 = 0xfe; //ʹADC16ƵVDD/4ͨ
    ADCR1 = 0x00; //12λH8L4ڲVDD15ADCLK
    ADEOC = 0;
    while (!ADEOC);
    g_cnt = 0;
    while (!(((ADRH >> 2) == 0x10) || ((ADRH >> 2) == 0x0F)))
    {
        ADEOC = 0;
        while (!ADEOC);
        g_cnt++;
        if (g_cnt >= 200)
            return; //ûӷֵ,ʾ
    }
}
/************************************************
;  *    @            : ADC_Zero_ADJ
;  *    @˵              : ADCУ׼,ûѡǷУ׼
;  *    @          :
;  *    @ز          :0 У׼ɹ  1У׼ʧ
;  ***********************************************/
uint8_t ADC_Zero_ADJ(void)
{
    ADCR0 = 0xff;           //ʹADC16ƵGNDͨ
    ADCR1 = 0x30;           //12λH8L4ڲ2V15ADCLK
    OSADJCR = DEF_SET_BIT7; //ʹУ׼޵
    ADEOC = 0;
    while (!ADEOC);
    if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) //ǷΪ0
    {
        OSADJTD = 1; //޵
        OSADJCR |= 0x3F;
        ADEOC = 0;
        while (!ADEOC);
        if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) //ǷΪ0
        {
            ADEN = 0;
            return PASS;
        }
        else
        {
            while (1)
            {
                if (OSADJCR & 0x3f)
                {
                    OSADJCR--;
                    ADEOC = 0;
                    while (!ADEOC);
                    if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) //ǷΪ0
                    {
                        ADEN = 0;
                        return PASS;
                    }
                }
                else
                {
                    ADEN = 0;
                    return FAIL;
                }
            }
        }
    }
    else
    {
        while (1)
        {
            if ((OSADJCR & 0x3f) == 0x3f)
            {
                ADEN = 0;
                return FAIL;
            }
            else
            {
                OSADJCR++;
                ADEOC = 0;
                while (!ADEOC);
                if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) //ǷΪ0
                {
                    ADEN = 0;
                    return PASS;
                }
            }
        }
    }
}
/************************************************
;  *    @            : ADC_Init
;  *    @˵              : ADCʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void ADC_Init(void)
{
    ADCR0 = 0xf0; //ʹADC16Ƶ
    ADCR1 = 0x30; //12λH8L4ڲ2V15ADCLK
}
/************************************************
;  *    @            : ADC_Get_Value_Average
;  *    @˵              : ת
;  *    @          : ͨ
;  *    @ز          : ADCֵ
;  ***********************************************/
uint ADC_Get_Value_Average(u8 CHX)
{
    g_temp_value = 0;
    g_channel = 0;
    g_tmpbuff = 0;
    g_adcmax = 0;
    g_adcmin = 0xffff;
    ADCR0 = (ADCR0 & 0xf0) | CHX; // ADC ʹ  ADתͨ  ͨ  CHX
    Delay(300);                   //лͨʱ200uS
    for (g_channel = 0; g_channel < 20; g_channel++)
    {
        ADEOC = 0;
        while (!ADEOC); //ȴת
        g_temp_value = ADRH;
        g_temp_value = g_temp_value << 4 | (ADRL & 0x0f);
        if (g_channel < 2)
            continue; //ǰβ
        if (g_temp_value > g_adcmax)
            g_adcmax = g_temp_value; //
        if (g_temp_value < g_adcmin)
            g_adcmin = g_temp_value; //С
        g_tmpbuff += g_temp_value;
    }
    g_tmpbuff -= g_adcmax;           //ȥһ
    g_tmpbuff -= g_adcmin;           //ȥһС
    g_temp_value = (g_tmpbuff >> 4); //16ȡƽֵ
    return g_temp_value;
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱ2mS
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT0 | DEF_SET_BIT1 | DEF_SET_BIT2; //CPU,128Ƶ
    T0CNT = 250 - 1;
    T0LOAD = 250 - 1; //2ms
    T0EN = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    ADC_Power_On_Stability();
    while (ADC_Zero_ADJ()); //demoʾ,У׼ʧһֱУ׼ûѡǷУ׼
    ADC_Init();
    TIMER0_INT_Init();
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    while (1)
    {
        if (T0IF) //2mS
        {
            T0IF = 0;
            g_adc_value0_temp = ADC_Get_Value_Average(0);
        }
        if (g_adc_value0_temp > 2048 + 1024) //>1.5V
        {
            P00D = 1;
            P01D = 0;
            P02D = 0;
            P03D = 0;
        }
        else if (g_adc_value0_temp > 2048) //>1V
        {
            P00D = 0;
            P01D = 1;
            P02D = 0;
            P03D = 0;
        }
        else if (g_adc_value0_temp > 1024) //>0.5V
        {
            P00D = 0;
            P01D = 0;
            P02D = 1;
            P03D = 0;
        }
        else //<0.5V
        {
            P00D = 0;
            P01D = 0;
            P02D = 0;
            P03D = 1;
        }
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
