/******************************************************************************
;  *       @ͺ                 : MC32F7062
;  *       @             : 2021.04.13
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : ΢ Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                    EEPROM
                      256ַд,ٶ;
                      дһ,P03˿500msת;
                      дݲһ,P03˿250msת
******************************************************************************/

#include "user.h"
/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;

    OEP0 = 0xff; //P0  out
    OEP1 = 0xff; //P1  out
    OEP2 = 0xff; //out

    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00; //out

    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              :
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT1 | DEF_SET_BIT2;//CPU,64Ƶ
    T0CNT = 250-1;
    T0LOAD = 250-1; //1ms
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @            : EEPROM_Write_Byte
;  *    @˵              : ڲEEPROMдһֽ
;  *    @          : ַ  
;  *    @ز          :
;  ***********************************************/
void EEPROM_Write_Byte(uint8_t addr, uint8_t data)
{
    EEAR = addr;
    EEDR = data;
    GIE = DISABLE;
    EEPR = 0x5A;
    EEPR = 0xA5; //
    EECR = 0x01;   //EEPROMд  дݲ
    Nop();
    Nop();
    while(EEWRITE)  // EE дǷ
    {
        ClrWdt(); //忴Ź
    }
    GIE = ENABLE;
}
/************************************************
;  *    @            : EEPROM_Read_Byte
;  *    @˵              : ڲEEPROMһֽ
;  *    @          : Addr  ַ
;  *    @ز          : 
;  ***********************************************/
uint8_t EEPROM_Read_Byte(u8 addr)
{
    EEAR = addr;
    EECR = 0x02;    // EE 
    while(EEREAD)   // EE дǷ
    {
        ClrWdt(); //忴Ź
    }
    return EEDR;
}
/************************************************
;  *    @            : EEPROM_Write_Data
;  *    @˵              : д
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void EEPROM_Write_Data(u8 addr, u8 *data, u8 len)
{
    while (len)
    {
        EEPROM_Write_Byte(addr++, *data++);
        len--;
    }
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = DISABLE;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    GIE = ENABLE;
}
const uint8_t EEPROM_test_num[64] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
    40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
    50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
    60, 61, 62, 63};    //д
uint8_t EEPROM_test_buff[64];           //Ի
void main(void)
{
    Sys_Init();
    EEPROM_Read_Flag = 0;
    for (g_count2 = 0; g_count2 < 4; g_count2++)
    {
        EEPROM_Write_Data(0+(g_count2<<6), EEPROM_test_num, 64); //д
        for (g_count1 = 0; g_count1 < 64; g_count1++)
        {
            EEPROM_test_buff[g_count1] = EEPROM_Read_Byte(g_count1+(g_count2<<6)); //ȡ
            if(EEPROM_test_buff[g_count1]!=EEPROM_test_num[g_count1])
            {
                EEPROM_Read_Flag = 1;
                break;
            }
        }
    }
    while (1)
    {
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
if ((T0IF) && (T0IE))
    {
        T0IF = 0;
        g_timercount++;
        if(EEPROM_Read_Flag)
        {
            if(g_timercount >= 250)
            {
                g_timercount = 0;
                P03D =! P03D;
            }
        }
        else
        {
            if(g_timercount >= 500)
            {
                g_timercount = 0;
                P03D =! P03D;
            }
        }
    }
__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
