/******************************************************************************
;  *       @ͺ                 : MC32F7082
;  *       @             : 2023.02.01
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : ΢ Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                              OPA
;  *                      P20D  OPAN
;  *                      P21D  OPAP
;  *                      P17D  OPAO
;  *                    ʹOPAʧѹУ
;  *                    ͬŴѹ0.1V  ѹ1.1V
;  *                    ӵ·οOPAͬŴ·
;  *                    ͬӷŴV10.1V,V20.2V ѹ1.65V
;  *                    ӵ·οOPAͬӷ·
******************************************************************************/

#include "user.h"

/************************************************
;  *    @            : Delay
;  *    @˵              : ʱFcpu = 2MHz
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Delay(u8 NUM)       
{
    for(dat=0;dat<NUM;dat++)
    {Nop();Nop();}
}

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;

    OEP0 = 0xff;
    OEP1 = 0x7f;   // 17 in
    OEP2 = 0xfc;   // P20 P21 in

    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;

    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;

    P1ADCR = 0x80;
    P2ADCR = 0x03;
}

/************************************************
;  *    @            : OPA_Init
;  *    @˵              : ˷
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void OPA_Init(void)
{
    OPACR0 = DEF_SET_BIT7 | DEF_SET_BIT2;   // 
    OPACR1 = 0x00;                          //ⲿOPAP
}

/************************************************
;  *    @            : OPA_ADJ
;  *    @˵              : OPAʧѹУ
;  *    @          :
;  *    @ز          :FAIL,PASS
;  ***********************************************/
uint8_t OPA_ADJ(void)
{
    OPACR0 = DEF_SET_BIT7 ;                 //ʹOPA,ģ
    OPACR0 &=~ DEF_SET_BIT2;                //ֹ˿
    OPACR1 = DEF_SET_BIT4 | DEF_SET_BIT3;   //VDDڲѹ
    OPACR1 |= DEF_SET_BIT0;                 //0.02VDD

    OPACLR |= DEF_SET_BIT7;                 //OPACLRE = 1;ʹģʽ 
    OPACLR |= DEF_SET_BIT6;                 //OPACLRS = 1;ΪοԴ
    //OPACLR &=~ DEF_SET_BIT6;                //OPACLRS = 0;ΪοԴ

    OPACLR &= 0xC0;                         //λ
    Delay(1000);                            //ʱ > 100us(ûɾʵʵ)
    OPAOF_FLAG = OPAOF;                     //ȡOPAOF
    OPAOFLOOP_FLAG = 1;
    while(OPAOFLOOP_FLAG)
    {
        OPACLR++;
        Delay(1000);                        //ʱ > 100us(ûɾʵʵ)
        if(OPAOF != OPAOF_FLAG)
        {
            OPAOFLOOP_FLAG = 0;             //תУɹ
        }
        else if((OPACLR<<2)== 0xFC)
        {
            return FAIL;                    //Уʧ
        }
    }
    if((OPACLR&0X20)!= 0X20)
    {
        OPACLR -= 1;                        //һΪУ׼ֵ
    }
    OPACLR &=~ DEF_SET_BIT7;                //OPACLRE = 0;رģʽ 
    return PASS;                            //Уɹ
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    while(OPA_ADJ());                       //OPAʧѹУ
    OPA_Init();
    GIE = 0;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main()
{
    Sys_Init();
    while(1)
    {
              
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}


