
/******************************************************************************
;  *       @ͺ                 : MC32F7062
;  *       @             : 2021.04.13
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : ΢ Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                      T1벶׽ 
                       ϵ벶׽벶׽жϺ㲶׽ʱ;
                       T0ģ⴮׽ʱ䡣
                       ׽ظ      1
                       벶׽ͨ    INT0    P20
                       ģ⴮ͨ    TX      P21
                                 9600
******************************************************************************/
#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : 
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0;   //ioλ
    IOP1 = 0;
    IOP2 = 0;

    OEP0 = 0xff;   //ioڷ 1:Out  0:IN
    OEP1 = 0xff;
    OEP2 = 0xf2;   //P21 Out P20 IN

    PUP0 = 0x00;   //io   1:enable  0:disable
    PUP1 = 0x00;
    PUP2 = 0x00;

    PDP0 = 0x00;   //io   1:enable  0:disable
    PDP1 = 0x00;
    PDP2 = 0x01;   //P20  
}
/************************************************
;  *    @            : Timer0_Init
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Timer0_Init(void)
{
    T0CR = 0x84;    //ʹT0 FCPU  16Ƶ
    // T0CNT = 104;
    // T0LOAD = 104;
    // T0IE = 1;
}
/************************************************
;  *    @            : TIMER1_In_init
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_In_init(void)
{
    T1CR0 = 0xC6;   // ʹT1 ʹ벶׽  64Ƶ
    T1CR1 = 0x84;   // INT0   ش  ½ֹ  ׽1
    T1CNTH = 0x00;
    T1CNTL = 0xfa;
    T1LOADH = 0x00;
    T1LOADL = 0xfa;    // 1ms
    g_timer_value_init = T1LOADH << 8;
    g_timer_value_init += T1LOADL;
    T1EN = 1;       // T1CNTݼ
    T1IE = 1;
    T1CIE = 1;      //T1׽ж
}
void UART_TX_Value(u8 data)
{
    Uart_TX_flag = 1;
    g_uart_tx_num = data;
    T0CNT = temp;
    T0LOAD = temp;
    T0EN = 1;
    T0IE = 1;
    while(Uart_TX_flag);    //ȴ
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
       Timer0_Init();
    TIMER1_In_init();
    GIE = 1;
}
void main(void)
{
    Sys_Init();
       TX = 1;
    T1CEOC = 0;     //׽
    while(1)
    {
        if(Timer_In_flag)
        {
            Timer_In_flag = 0;
            T1IE = 0;
            g_high_level_time = T1CNTL;
            g_high_level_time += T1CNTH << 8;           //ȶλٶλ
            g_timer_value_data = g_timer_value_init - g_high_level_time;         //ȡݼ
            g_timer_value_data = g_timer_value_data*4;                                  //ܵݼ x εݼʱ
            g_high_level_time = g_timer_value_data + g_timer1_count*1000;     //ʱ + ۼʱ
            g_uart_tx_num = g_high_level_time >> 24;
            UART_TX_Value(g_uart_tx_num);
            g_uart_tx_num = g_high_level_time >> 16;
            UART_TX_Value(g_uart_tx_num);
            g_uart_tx_num = g_high_level_time >> 8;
            UART_TX_Value(g_uart_tx_num);
            g_uart_tx_num = g_high_level_time & 0xff;
            UART_TX_Value(g_uart_tx_num);
                     UART_TX_Value(0x0d);
                     UART_TX_Value(0x0a);
                     g_high_level_time = 0;
                     g_timer1_count = 0;
                     T1LOADH = 0x00;
                  T1LOADL = 0xfa;
                     T1IE = 1;
            T1CEOC = 0;     //׽
        }
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if((T0IF)&&(T0IE))
    {
        T0IF = 0;
        if(g_tx_bit_num == 0)     //ʼλ
        {
            TX = 0;
            g_tx_bit_num++;       //λһ
        }
        else if(g_tx_bit_num < 9) //λ
        {
            if(g_uart_tx_num&0x01)
            {
                TX = 1;
            }
            else TX = 0;
            g_tx_bit_num++;       //λһ
            g_uart_tx_num >>= 1;  //λȴһη
        }
        else if(g_tx_bit_num < 10)// ֹλ
        {
            TX = 1;
            g_tx_bit_num++;       //Ƴ
        }
        else
        {
            Uart_TX_flag = 0;
            g_tx_bit_num = 0;     //λ
            T0IE = 0;
            T1IE = 1;
        }
    }
    if ((T1IF) && (T1IE))
    {
        T1IF = 0;
              P01D = !P01D;
        g_timer1_count++;
    }
    if ((T1CIF) && (T1CIE))
    {
        T1CIF = 0;
        Timer_In_flag = 1;
    }
__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}