/******************************************************************************
;  *       @ͺ                 : MC32F7062
;  *       @             : 2021.04.13
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : ΢ Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                      жϻ
                        P12,
                        P00 1mSת,Ѻ500mS
***************************** *************************************************/

#include "user.h"
/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;

    OEP0 = 0xff; //P0  out
    OEP1 = 0xfb; //P12  in
    OEP2 = 0xff; //out

    PUP0 = 0x00;
    PUP1 = 0x04; //P12UP
    PUP2 = 0x00;

    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              :
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT0 | DEF_SET_BIT1 | DEF_SET_BIT2; //CPU,128Ƶ
    T0CNT = 125 - 1;
    T0LOAD = 125 - 1; //1ms
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    P12KE = 1; //ʹP12ж
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    LFEN = 0; //ʱرյƵ
    while (1)
    {
        if (FLAG_TIMER0_500ms)
        {
            FLAG_TIMER0_500ms = 0;
            GIE = 0;
            KBIE = 1; //ʹܼжϻ
            P00D = 0; //ر
            Stop();
            Nop();
            Nop();
            KBIF = 0;
            KBIE = 0; //رռж
            GIE = 1;
        }
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((T0IF) && (T0IE))
    {
        P00D = !P00D;
        T0IF = 0;
        timer0_cnt1++;
        if (timer0_cnt1 >= 500)
        {
            timer0_cnt1 = 0;
            FLAG_TIMER0_500ms = 1;
        }
    }
__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
