/******************************************************************************
;  *       @ͺ                 : MC32F7062
;  *       @             : 2021.04.13
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : ΢ Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                             ⲿж
                    INT0:P20 ½ش P03ת
                    INT1:P21 ش P04ת
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;

    OEP0 = 0xff; //P0  out
    OEP1 = 0xff; //P1  out
    OEP2 = 0xfc; //P20  P21 in

    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = DEF_SET_BIT0; //P20

       PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = DEF_SET_BIT1; //P21
}
/************************************************
;  *    @            : INT_Init
;  *    @˵              : ⲿжϳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void INT_Init(void)
{
    MCR &= ~(DEF_SET_BIT0 | DEF_SET_BIT1 | DEF_SET_BIT2 | DEF_SET_BIT3);
    MCR |= DEF_SET_BIT0; //INT0  ½ش  INT1  ش
    INT0IE = 1;          //ʹINTж
    INT1IE = 1;

       INT0IF = 0;                   //ⲿжϱ־λ
       INT1IF = 0;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    INT_Init();
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    while (1)
    {
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
   movra _statusbuf
__endasm;
    if ((INT0IF) && (INT0IE))
    {
        P03D = !P03D;
        INT0IF = 0;
    }
    if ((INT1IF) && (INT1IE))
    {
        P04D = !P04D;
        INT1IF = 0;
    }

__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
