/******************************************************************************
;  *       @ͺ                 : MC32F7062
;  *       @             : 2021.04.13
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : ΢ Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                             ʱ--PWM3  
                                   P00P01  F=10K,D=20%,DT=8uS
***************************** *************************************************/
#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;

    OEP0 = 0xff; //P0  out
    OEP1 = 0xff; //P1  out
    OEP2 = 0xff; //out

    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;

    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
}
/************************************************
;  *    @            : TIMER3_PWM_Init
;  *    @˵              :
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER3_PWM_Init(void)
{
    T3CNT = 100 - 1;
    T3LOAD = 100 - 1;
    T3DATA = 20;
    T3CR = DEF_SET_BIT6 | DEF_SET_BIT5 | DEF_SET_BIT2;//PWM3A FPWM3A ʹ,CPU,16Ƶ
    PWM3CR1 = DEF_SET_BIT1 | DEF_SET_BIT0;//P00P01
    PWM3CR3 = DEF_SET_BIT2 | DEF_SET_BIT1 | DEF_SET_BIT0;  //8ʱ
    T3EN = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER3_PWM_Init();
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    while (1)
    {
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
