/******************************************************************************
;  *       @ͺ                 : MC32F7062
;  *       @             : 2021.04.13
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : ΢ Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                    ʱ
                    T0   P00 1mSת
                    T1   P01 100uSת
                    T2   P02 50uSת
                    T3   P03 25uSת
***************************** *************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;

    OEP0 = 0xff; //P0  out
    OEP1 = 0xff; //P1  out
    OEP2 = 0xff; //out

    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;

    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              :
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT1 | DEF_SET_BIT2;//CPU,64Ƶ
    T0CNT = 250-1;
    T0LOAD = 250-1; //1ms
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @            : TIMER1_INT_Init
;  *    @˵              :
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR0 = DEF_SET_BIT2; //ʱģʽ,CPU,16Ƶ
    T1CNTH = 0;
    T1CNTL = 100 - 1;
    T1LOADH = 0; //100us
    T1LOADL = 100 - 1;
    T1EN = 1;
    T1IE = 1;
}
/************************************************
;  *    @            : TIMER2_INT_Init
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER2_INT_Init(void)
{
    T2CR = DEF_SET_BIT0 | DEF_SET_BIT1; //CPU,8Ƶ
    T2CNT = 100 - 1;
    T2LOAD = 100 - 1; //50us
    T2EN = 1;
    T2IE = 1;
}
/************************************************
;  *    @            : TIMER3_INT_Init
;  *    @˵              :
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER3_INT_Init(void)
{
    T3CR = DEF_SET_BIT1; //CPU,4Ƶ
    T3CNT = 100 - 1;
    T3LOAD = 100 - 1; //25us
    T3EN = 1;
    T3IE = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    TIMER1_INT_Init();
    TIMER2_INT_Init();
    TIMER3_INT_Init();
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    while (1)
    {
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((T0IF) && (T0IE))
    {
        P00D = !P00D;
        T0IF = 0;
    }
    if ((T1IF) && (T1IE))
    {
        P01D = !P01D;
        T1IF = 0;
    }
    if ((T2IF) && (T2IE))
    {
        P02D = !P02D;
        T2IF = 0;
    }
    if ((T3IF) && (T3IE))
    {
        P03D = !P03D;
        T3IF = 0;
    }

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
