/******************************************************************************
;  *       @ͺ                 : MC32F7062
;  *       @             : 2021.04.13
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : ΢ Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                 ʱ--Ƶ
                    T0   P00 2mSת
                    T1   P01 100uSת
***************************** *************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;

    OEP0 = 0xff; //P0  out
    OEP1 = 0xff; //P1  out
    OEP2 = 0xff; //out

    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;

    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              :
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT0 | DEF_SET_BIT1 | DEF_SET_BIT2; //CPU,128Ƶ
    T0CNT = 125 - 1;
    T0LOAD = 125 - 1; //2ms
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @            : TIMER1_INT_Init
;  *    @˵              :
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR0 = DEF_SET_BIT2 | DEF_SET_BIT3; //ʱģʽ,FHOSC,16Ƶ
    T1CNTH = 0;
    T1CNTL = 100 - 1;
    T1LOADH = 0; //100us
    T1LOADL = 100 - 1;
    T1EN = 1;
    T1IE = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    TIMER1_INT_Init();
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    g_pfrcr_back = HIRCCAL; //Ƶ΢У׼λ
    g_pfrcr_temp = g_pfrcr_back;
    while (1)
    {
        if (FLAG_TIMER0_10ms) //10mS޸һ
        {
            FLAG_TIMER0_10ms = 0;
            if (FLAG_PFRCR_ADD_DEC)
            {
                if (g_pfrcr_temp < g_pfrcr_back)
                {
                    g_pfrcr_temp++;
                }else FLAG_PFRCR_ADD_DEC = 0;//ӵPFRCR_back   ʼݼ
            }
            else
            {
                if(g_pfrcr_temp>0)
                {
                    g_pfrcr_temp--;
                }else FLAG_PFRCR_ADD_DEC = 1;//0  ʼ
            }
                     HIRCCAL = g_pfrcr_temp; //޸΢Ĵ
        }
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((T0IF) && (T0IE))
    {
        P00D = !P00D;
        g_timer0_cnt1++;
        if (g_timer0_cnt1 >= 10)
        {
            g_timer0_cnt1 = 0;
            FLAG_TIMER0_10ms = 1;
        }
        T0IF = 0;
    }
    if ((T1IF) && (T1IE))
    {
        P01D = !P01D;
        T1IF = 0;
    }

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
