/******************************************************************************
;  *   	@ͺ	   	   	   	  : MC30F6910
;  *   	@             : 2021.08.04
;  *   	@˾/ 	   	   	  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	   	   	   	TIME  ʱʹ
;  *   	   	   	   	T0 	1mSж  P15ת
;  *   	   	   	   	T1 	100uSж P14ת
******************************************************************************/
#include    "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            :
;  *    @        :
;  *    @ز        :
;  ***********************************************/

void  CLR_RAM(void)
{
    for(FSR = 0xBF; FSR > 0x8F ; FSR--)
    {
        INDF = 0;
    }
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void  IO_Init(void)
{
    P1 = 0x00;
    DDR1 = 0x00;    // 1:input 0:output
    PUCON1 = 0xff;  // 0:Effective 1:invalid
    PDCON1 = 0xff;  // 0:Effective 1:invalid
    ODCON1 = 0x00;  //0:  1:© 

}

/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱT0
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void  TIMER0_INT_Init(void)
{
        T0CR = 0x05;   //ʱԴΪCPUʱ  ʱ64Ƶ   1ms
        TMRCR = 0x00;
        T0CNT = 256 - 125;
        T0IE = 1;        
}

/************************************************
;  *    @            : TIMER1_INT_Init
;  *    @˵              : ʱT1
;  *    @          :
;  *    @ز          :
;  ***********************************************/
 void TIMER1_INT_Init(void)
 {
       T1CR = 0x03;     //ʱԴΪCPUʱӣʱ8Ƶ 
       T1CNT = 100-1;   //100us
       T1LOAD = 100-1;
       T1EN = 1;
       T1IE = 1; 
 }

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void  Sys_Init(void)
{
       GIE = 0;
       CLR_RAM();
       IO_Init();
       TIMER0_INT_Init();
       TIMER1_INT_Init();
       GIE = 1; 
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void  main(void)
{
    Sys_Init();
    while(1)
    {
       
        
    }

}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void  int_isr(void) __interrupt
{
   	__asm
   	movra   _abuf
    swapar  _STATUS
    movra   _statusbuf
__endasm;

    if((T0IF) && (T0IE))
    {
        T0IF = 0;
        T0CNT = 256 - 125;
        P15D =! P15D;
    }

    if((T1IF) && (T1IE))
    {
        T1IF = 0;
        P14D =! P14D;
    }

__asm
   	swapar  _statusbuf
    movra   _STATUS
    swapr   _abuf
    swapar  _abuf
__endasm;

}

/**************************** end of file *********************************************/