/******************************************************************************
;  *       @ͺ                 : MC32F7361
;  *       @             : 2021.12.21
;  *       @˾/            : SINOMCU-FAE
;  *       @΢֧       : 2048615934
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *               LVD(ⲿ)
;  *               VDDѹ4V,P10,֮                                             
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0x3F;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x0F;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea

    PMOD = 0x00;                       //P00P01P13 io˿ֵӼĴ
    DRVCR = 0x80;                      //ͨ
}
/************************************************
;  *    @            : LVD_Init
;  *    @˵              : LVDʼ
;  *    @          : 
;  *    @ز          : 
;  ***********************************************/
void LVD_Init(void)
{
    LVDCR = 0x70;//4V
    LVDEN=1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    LVD_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if(LVDF == 1)                  //ѹ
        {
            P10D = 0;
        }else
        {
            P10D = 1;
        }
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
