/******************************************************************************
;  *       @ͺ                 : MC32F7361
;  *       @             : 2021.12.21
;  *       @˾/            : SINOMCU-FAE
;  *       @΢֧       : 2048615934
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                   SLEEP
;  *                   5sģʽP10͵ƽ
;  *                   P11жϻѣP10ߵƽ                               
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0x3F;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x0F;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea

    PMOD = 0x00;                       //P00P01P13 io˿ֵӼĴ
    DRVCR = 0x80;                      //ͨ
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱ0ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT0 | DEF_SET_BIT2;//CPU,32Ƶ
    T0CNT = 250-1;
    T0LOAD = 250-1;                    //1ms
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @            : KBIE_Init
;  *    @˵              : KBIEʼ
;  *    @          : 
;  *    @ز          : 
;  ***********************************************/
void KBIE_Init(void)
{
    OEP1 = 0xfd;                       //in
    PUP1 = 0x02;                       //
    P1KBCR = 0x02;                     //P11ж
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    KBIE_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if (FLAG_TIMER0_5000MS)
        {
            FLAG_TIMER0_5000MS = 0;
            GIE = 0;
            KBIF = 0;
            KBIE = 1;
            //ǰر AD ʹܻж
            P10D = 0;
            Nop();
            Nop();
            Stop();
            Nop();
            Nop();
            KBIE = 0;
            KBIF = 0;
            GIE = 1;
            //ѺʹرռжϣʵӦû
            P10D=1;
        }
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    //=======T0========================
    if (T0IF & T0IE)
    {
    T0IF = 0;
        g_timer0_num++;
        if (g_timer0_num >= 5000)        //5s
        {
            g_timer0_num = 0;
            FLAG_TIMER0_5000MS = 1;
        }
    }
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
