/******************************************************************************
;  *       @ͺ                 : MC32F7361
;  *       @             : 2021.12.21
;  *       @˾/            : SINOMCU-FAE
;  *       @΢֧       : 2048615934
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                ʱ
;  *                T0   P10 2mSת
;  *                T1   P11 1mSת
;  *                T2   P12 100uSת
;  *                T3   P14 50uSת                                            
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0x3F;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x0F;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea

    PMOD = 0x00;                       //P00P01P13 io˿ֵӼĴ
    DRVCR = 0x80;                      //ͨ
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱ0ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT1 | DEF_SET_BIT2;//CPU,64Ƶ
    T0CNT = 250-1;
    T0LOAD = 250-1;                    //2ms
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @            : TIMER1_INT_Init
;  *    @˵              : ʱ1ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = DEF_SET_BIT0 | DEF_SET_BIT2;//ʱģʽ,CPU,32Ƶ
    T1CNT = 250 - 1;                   //1ms
    T1LOAD = 250 - 1;
    T1EN = 1;
    T1IE = 1;
}
/************************************************
;  *    @            : TIMER2_INT_Init
;  *    @˵              : ʱ2ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER2_INT_Init(void)
{
    T2CR = DEF_SET_BIT0 | DEF_SET_BIT1;//CPU,8Ƶ
    T2CNT = 100 - 1;
    T2LOAD = 100 - 1;                  //100us
    T2EN = 1;
    T2IE = 1;
}
/************************************************
;  *    @            : TIMER3_INT_Init
;  *    @˵              : ʱ3ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER3_INT_Init(void)
{
    T3CR = DEF_SET_BIT1;               //CPU,4Ƶ
    T3CNT = 100 - 1;
    T3LOAD = 100 - 1;                  //50us
    T3EN = 1; 
    T3IE = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    TIMER1_INT_Init();
    TIMER2_INT_Init();
    TIMER3_INT_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {

    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    //=======T0========================
    if (T0IF & T0IE)
    {
        P10D = !P10D;
        T0IF = 0;
    }
    //=======T1========================
    if (T1IF & T1IE)
    {
        P11D = !P11D;
        T1IF = 0;
    }
    //=======T2========================
    if (T2IF & T2IE)
    {
        P12D = !P12D;
        T2IF = 0;
    }
    //=======T3========================
    if (T3IF & T3IE)
    {
        P14D = !P14D;
        T3IF = 0;
    }
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
