/******************************************************************************
;  *       @ͺ                 : MC32F7361
;  *       @             : 2021.12.21
;  *       @˾/            : SINOMCU-FAE
;  *       @΢֧       : 2048615934
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                PFRCƵ
;  *                T0   P10 10mSת ޸PFRCCAL ΢T1ʱ
;  *                T1   P11 100uSת                                  
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0 ++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0x3F;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x0F;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea

    PMOD = 0x00;                       //P00P01P13 io˿ֵӼĴ
    DRVCR = 0x80;                      //ͨ
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱ0ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT0 | DEF_SET_BIT2;//CPU,32Ƶ
    T0CNT = 250 - 1;
    T0LOAD = 250 - 1;                  //1ms
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @            : TIMER1_INT_Init
;  *    @˵              : ʱ1ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = DEF_SET_BIT2;               //ʱģʽ,Fcpu,16Ƶ
    T1CNT = 100 - 1;                   //100us
    T1LOAD = 100 - 1;
    T1EN = 1;
    T1IE = 1;
}
/************************************************
;  *    @            : delay_us
;  *    @˵              : ȷʱ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void delay_us(uint8_t num)             //CPU=8M
{
    for (i = 0; i < num; i ++)
    {
        Nop();
        Nop();
    }
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    PFRCCR = DEF_SET_BIT7 | DEF_SET_BIT2;//ʹPFRCT1ʱԴΪPFRC/2
    delay_us(20);                        //PFRCENʱ20uSϲӦ
    g_pfrc_back = PFRCCAL;               //Ƶ΢У׼λ
    g_pfrc_temp = PFRCCAL;
    IO_Init();
    TIMER0_INT_Init();
    TIMER1_INT_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if (FLAG_TIMER0_10MS)            //10mS޸һ
        {
            FLAG_TIMER0_10MS = 0;
            PFRC_User();                 //PFRC΢
        }
    }
}
/************************************************
;  *    @            : PFRC_User
;  *    @˵              : PFRC΢
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void PFRC_User(void)
{
    PFRCCAL = g_pfrc_temp;               //޸΢Ĵ
    if (FLAG_PFRCR_ADD_DEC)
    {
        g_pfrc_temp ++;
        if (g_pfrc_temp >= 255)          //0  ʼ
        {
            FLAG_PFRCR_ADD_DEC = 0;
        }
    }
    else
    {
        g_pfrc_temp --;
        if (g_pfrc_temp == 0)            //ӵ255   ʼݼ
        {
            FLAG_PFRCR_ADD_DEC = 1;
        }
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    //=======T0========================
    if(T0IF&T0IE)
    {
        g_timer0_cnt1 ++;
        if (g_timer0_cnt1 >= 10)
        {
            P10D =! P10D;
            g_timer0_cnt1 = 0;
            FLAG_TIMER0_10MS = 1;
        }
        T0IF = 0;
    }
    //=======T1========================
    if ((T1IF) && (T1IE))
    {
        P11D = !P11D;
        T1IF = 0;
    }
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
