/******************************************************************************
;  *    @ͺ                  : MC30P6290
;  *    @              :  2022.04.14
;  *    @˾/             : SINOMCU-FAE
;  *    @΢            : http://www.sinomcu.com/
;  *    @Ȩ                  : 2022 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                    TIME  ʱʹ
                        T0  1mSж  P14ת
                        T1  100uSж P12ת
******************************************************************************/


#include "user.h"

/************************************************
;  *    @            : C_RAM
;  *    @˵                : RAM
;  *    @            :
;  *    @ز            :
;  ***********************************************/
void C_RAM(void)
{
    __asm
    movai 0x3F
    movra FSR
    movai 47
    movra 0x3F
    decr FSR
    clrr INDF
    djzr 0x3F
    goto $ -3;
    clrr 0x3F
    __endasm;
}

/************************************************
;  *    @            : IO_Init
;  *    @˵                : IOʼ
;  *    @            :
;  *    @ز            :
;  ***********************************************/
void IO_Init(void)
{
    P1 = 0x00;               //IOλ
    DDR1 = 0x00;             //1:input 0:output
    PUCON = 0xff;            //IO   0:Effective 1:invalid
    PDCON = 0xff;            //IO   0:Effective 1:invalid
    ODCON = 0x00;            //0:  1:©
}

/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵                : ʱ0ʼ
;  *    @            :
;  *    @ز            :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = 0x05;             //ʱΪCPUʱ    ʱ64Ƶ  1ms
    T0CNT = 256 - 125;
    T0IE = 1;
}

/************************************************
;  *    @            : TIMER1_INT_Init
;  *    @˵                : ʱ1ʼ
;  *    @            :
;  *    @ز            :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = 0x03;             //Fcpu 8Ƶ 
    T1CNT = 100-1;
    T1LOAD = 100-1;          //100uS
    T1EN = 1;
    T1IE = 1;
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵                : ϵͳʼ
;  *    @            :
;  *    @ز            :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    C_RAM();
    IO_Init();
    TIMER0_INT_Init();
    TIMER1_INT_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵                : 
;  *    @            :
;  *    @ز            :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵                : жϺ
;  *    @            :
;  *    @ز            :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _STATUS
    movra _statusbuf
__endasm;

    if ((T0IF) && (T0IE))
    {
        T0IF = 0;
        T0CNT = 256 - 125;
        P14D = !P14D;
    }

    if ((T1IF) && (T1IE))
    {
        T1IF = 0;
        P12D = !P12D;
    }
__asm
    swapar _statusbuf
    movra _STATUS
    swapr _abuf
    swapar _abuf
__endasm;
}


/**************************** end of file *********************************************/