/**
  ******************************************************************************
  * @file           : main.c
  * @author         : SINOMCU-AE
  * @brief          : Main program body
  *    
  *          This file provides example code for GPIO Toggle speed test
  * For details, see "readme.txt"   
  *         
  ******************************************************************************
   * @attention 
  *                           DISCLAIMER
  * The present firmware which is for guidance only aims at providing customers
  * with coding information regarding their products in order for them to save
  * time. As a result, SinoMCU shall not be held liable for any direct,indirect
  * or consequential damages with respect to any claims arising from the content 
  * of such firmware and/or the use made by customers of the coding information 
  * contained herein in connection with their products.
  *
  * <h2><center>&copy; Copyright (c) 2021 sinomcu All rights reserved.</center></h2>
  *
  ******************************************************************************
  */  
  
#include "system_define.h"

#define USE_ASM_TEST      0

/**
  * @brief  Main program
  * @param  None
  * @retval None
  */
int main(void) {
  SystemClock_Config();           // sysclk 48M,HSI 8M /2*12;if not call this function,default HSI 8M

  GPIO_Init();
#if(defined(USE_ASM_TEST) && USE_ASM_TEST)      
  // ASM test PB6 toggle
  speed_test();
#else    
  // C teset PB6 toggle
  while(1) {
    GPIOB->ODR  = 0x00000040;
    GPIOB->ODR  = 0x00000000;
    GPIOB->ODR  = 0x00000040;
    GPIOB->ODR  = 0x00000000;
  }
#endif
}

/**
  * @brief  SystemClock_Config PLL 48M
  * @param  None
  * @retval None
  */
void SystemClock_Config(void) {
  MS32_FLASH_SetLatency(MS32_FLASH_LATENCY_1);
  while(MS32_FLASH_GetLatency() != MS32_FLASH_LATENCY_1){ ; }
  MS32_RCC_HSI_Enable();

  // Wait HSI is ready
  while(MS32_RCC_HSI_IsReady() != 1){ ; }
 
  MS32_RCC_PLL_ConfigDomain_SYS(MS32_RCC_PLLSOURCE_HSI_DIV_2, MS32_RCC_PLL_MUL_12);
  MS32_RCC_PLL_Enable();

  // Wait PLL is ready 
  while(MS32_RCC_PLL_IsReady() != 1){ ; }

  MS32_RCC_SetAHBPrescaler(MS32_RCC_SYSCLK_DIV_1);
  MS32_RCC_SetAPB1Prescaler(MS32_RCC_APB1_DIV_1);
  MS32_RCC_SetSysClkSource(MS32_RCC_SYS_CLKSOURCE_PLL);

  // Wait System clock is ready
  while(MS32_RCC_GetSysClkSource() != MS32_RCC_SYS_CLKSOURCE_STATUS_PLL){ ; }
}

/******************************** END OF FILE *********************************/
