/**
  ******************************************************************************
  * @file     GPIO_CFG.c
  * @author   SINOMCU-AE
  * @brief    GPIO config
  *    
  *          This file provides functions to GPIO config:
  *              LED1 pin pushpull,output,pull down
  *         
  ******************************************************************************
  * @attention 
  *                           DISCLAIMER
  * The present firmware which is for guidance only aims at providing customers
  * with coding information regarding their products in order for them to save
  * time. As a result, SinoMCU shall not be held liable for any direct,indirect
  * or consequential damages with respect to any claims arising from the content 
  * of such firmware and/or the use made by customers of the coding information 
  * contained herein in connection with their products.
  *
  * <h2><center>&copy; Copyright (c) 2021 sinomcu All rights reserved.</center></h2>
  *
  ******************************************************************************
  */

#include "GPIO_CFG.h"

/**
  * @brief  GPIO Initialization Function
  * @param  None
  * @retval None
  */
void GPIO_Init(void)
{
  MS32_GPIO_InitTypeDef  GPIO_InitStruct;
  
  MS32_AHB1_GRP1_EnableClock(LED1_AHB_PERIPH_Port);

  // LED GPIO out pulldown 
  MS32_GPIO_StructInit(&GPIO_InitStruct);  
  GPIO_InitStruct.Pin = LED1_Pin;
  GPIO_InitStruct.Mode = MS32_GPIO_MODE_OUTPUT;
  GPIO_InitStruct.OutputType = MS32_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Speed = MS32_GPIO_SPEED_HIGH;
  GPIO_InitStruct.Pull = MS32_GPIO_PULL_DOWN;
  GPIO_InitStruct.Alternate = MS32_GPIO_AF_0;
  MS32_GPIO_Init(LED_Port,&GPIO_InitStruct);
}

/******************************** END OF FILE *********************************/
