/******************************************************************************
;  *       @ͺ                 : MC32P7351
;  *       @             : 2022.12.16
;  *       @˾/            : sinomcu.com-FAE
;  *       @΢֧       : 2048615934
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2022 sinomcu.com˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *               HOLDģʽ2
;  *               T0(ʱڲ32K)1S        P10P11ת
;  *               ڲ32K50%                                             
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    ADIOS0 = 0x00;                     //˿ڵֹ    1disable

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    ADIOS1 = 0x00;                     //˿ڵֹ    1disable

    PMOD = 0x07;                       //bit7-bit5 P17P13P01 ioѡ 1:ģ  0:ͨio 
                                       //bit2-bit0 P13P01P00 io˿ģʽ  1: 0:©
    DRVCR = 0x80;                      //ͨ
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱ0ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT0 | DEF_SET_BIT1 | DEF_SET_BIT2 | DEF_SET_BIT4;//Ƶ,128Ƶ
    T0CNT = 250 - 1;
    T0LOAD = 250 - 1; //1s
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    HFEN=0;
    LFEN=1;                            //رոƵ,ڲƵʼչ
    while (1)
    {
        Nop();
        Nop();
        Stop();   
        Nop();
        Nop();
        P11D =! P11D;
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    //=======T0========================
    if (T0IF & T0IE)
    {
        P10D =! P10D;
        T0IF = 0;
    }
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
