/******************************************************************************
;  *       @ͺ                 : MC32P7351
;  *       @             : 2022.12.16
;  *       @˾/            : sinomcu.com-FAE
;  *       @΢֧       : 2048615934
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2022 sinomcu.com˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *               TIMER0 P02ΣF=10k,D=25%
;  *               TIMER1 P16P17ΣF=10k,D=25%,DT=4us
;  *               TIMER2 P11P12P14P15黥ΣF=10k,D=25%,DT=4us                                              
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    ADIOS0 = 0x00;                     //˿ڵֹ    1disable

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    ADIOS1 = 0x00;                     //˿ڵֹ    1disable

    PMOD = 0x07;                       //bit7-bit5 P17P13P01 ioѡ 1:ģ  0:ͨio 
                                       //bit2-bit0 P13P01P00 io˿ģʽ  1: 0:©
    DRVCR = 0x80;                      //ͨ
}
/************************************************
;  *    @            : TIMER0_PWM_Init
;  *    @˵              : ʱ0,PWMʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_PWM_Init(void)
{
    T0CR = DEF_SET_BIT6 | DEF_SET_BIT0 | DEF_SET_BIT1;     //ʹPWM,CPU,8Ƶ
    T0CNT = 100-1;
    T0LOAD = 100-1;                                        //100us
    T0DATA = 25;
    PWMCR0 = 0x00;                                         //
    PWMCR1 = 0x00;                                         //ͨģʽ
    PWMCR3 = DEF_SET_BIT2;                                 //P02˿
    T0EN = 1;
}

/************************************************
;  *    @            : TIMER1_PWM_Init
;  *    @˵              : ʱ1,PWMʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_PWM_Init(void)
{
    T1CR = DEF_SET_BIT6 | DEF_SET_BIT1 | DEF_SET_BIT0;                    //ʹPWM,CPU,8Ƶ
    T1CNT = 100-1;
    T1LOAD = 100-1;                                                       //100us
    T1DATA = 25;
    PWMCR0 |= DEF_SET_BIT7 | DEF_SET_BIT3 | DEF_SET_BIT2 | DEF_SET_BIT0;  //ʹFPWM4ʱ
    PWMCR1 = 0x00;                                                        //ͨģʽ
    T1EN = 1;
}
/************************************************
;  *    @            : TIMER2_PWM_Init
;  *    @˵              : ʱ2,PWMʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER2_PWM_Init(void)
{
    T2CR = DEF_SET_BIT6 | DEF_SET_BIT0 | DEF_SET_BIT1;     //ʹPWM,CPU,8Ƶ
    T2CNT = 100-1;
    T2LOAD = 100-1;                                        //100us
    T2DATA = 25;
    PWMCR1 = 0x00; 
    PWMCR2 = 0x03;                                         //4ʱ
    PWMCR3 |= DEF_SET_BIT6 | DEF_SET_BIT5 | DEF_SET_BIT4;  //ʹFPWM,NPWM,
    T2EN = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_PWM_Init();
    TIMER1_PWM_Init();
    TIMER2_PWM_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {

    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
   
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
