/******************************************************************************
;  *       @ͺ                 : MC32P7351
;  *       @             : 2022.12.16
;  *       @˾/            : sinomcu.com-FAE
;  *       @΢֧       : 2048615934
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2022 sinomcu.com˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                HIRC Ƶ ΢CPUʱ
;  *                (̽ΪοһֱڵƵ)
;  *                T0   P10 10mSת ޸HIRCCAL
;  *                T1   P11 100uSת                                  
******************************************************************************/

#include "user.h"
/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0 ++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0x3F;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    ADIOS0 = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    ADIOS1 = 0x00;                     //ioѡ  1:ģ  0:ͨio

    PMOD = 0x07;                       //bit7-bit5 P17P13P01 ioѡ 1:ģ  0:ͨio 
                                       //bit2-bit0 P13P01P00 io˿ģʽ  1: 0:©
    DRVCR = 0x80;                      //ͨ
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱ0ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT0 | DEF_SET_BIT2;//CPU,32Ƶ
    T0CNT = 250 - 1;
    T0LOAD = 250 - 1;                  //1ms
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @            : TIMER1_INT_Init
;  *    @˵              : ʱ1ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = DEF_SET_BIT0 | DEF_SET_BIT1;//ʱģʽ,CPU,8Ƶ
    T1CNT = 100 - 1;                   //100us
    T1LOAD = 100 - 1;
    T1EN = 1;
    T1IE = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    TIMER1_INT_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    g_hirc_back = HIRCCAL;             //Ƶ΢У׼λ
    g_hirc_temp = g_hirc_back;
    while (1)
    {
        if (FLAG_TIMER0_10ms)          //10mS޸һ
        {
            FLAG_TIMER0_10ms = 0;
            HIRC_User();               //Ƶ΢
        }
    }
}
/************************************************
;  *    @            : HIRC_User
;  *    @˵              : Ƶ΢
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void HIRC_User(void)
{
    if (FLAG_PFRCR_ADD_DEC)
    {
        if (g_hirc_temp < g_hirc_back)
        {
            g_hirc_temp ++;
        }else FLAG_PFRCR_ADD_DEC = 0;  //ӵPFRCR_back   ʼݼ
    }
    else
    {
        if(g_hirc_temp > 0)
        {
            g_hirc_temp --;
        }else FLAG_PFRCR_ADD_DEC = 1;  //0  ʼ
    }
    HIRCCAL = g_hirc_temp;             //޸΢Ĵ
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    //=======T0========================
    if(T0IF&T0IE)
    {
        g_timer0_cnt1++;
        if (g_timer0_cnt1 >= 10)
        {
            g_timer0_cnt1 = 0;
            FLAG_TIMER0_10ms = 1;
            P10D =! P10D;
        }
        T0IF = 0;
    }
    //=======T1========================
    if ((T1IF) && (T1IE))
    {
        P11D =! P11D;
        T1IF = 0;
    }
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
