/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.04
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                Ƚ2
;  *             15ʱ
;  *             ѡ0.5VDD
;  *             ѡⲿCP2N0 P03
;  *             ½شжP06ת
;  *             ʧѹ
;  *         ûѡǷҪеУ
***עCMP˿ڽֹգģѹΧ0-VDD-1.4
******************************************************************************/

#include "user.h"
/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : Delay
;  *    @˵              : ȷʱ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Delay(u16 num)
{
    for (i = 0; i < num; i ++)
    {
        Nop();
    }
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x03;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea
}
/************************************************
;  *    @            : CMP2_ADJ
;  *    @˵              :ȽУ׼
;  *    @          :
;  *    @ز          : 0 У׼ɹ  1У׼ʧ
;  ***********************************************/
uint8_t CMP2_ADJ(void)
{
    CPCR0   = DEF_SET_BIT2;            //CMP2ʹ
    CP2CLRE = ENABLE;                  //ʹCMP2ģʽ
    // CP2CLRS = 0;                      //ο
    CP2CLRS = ENABLE;                  //ο
    CPVR0 = 0x50;                      //˻׼ѹ0.5V*VDD
    CP2CLR &= 0xc0;                    //õ6λ=0
    Delay(200);                        //ʱ >100US
    CMPOF_FLAG = CP2OF;                //ȡֵ
    while(ENABLE)
    {
        CP2CLR++;   
        Delay(200);
        if(CP2OF != CMPOF_FLAG)        //жǷУ׼
         break;                        //У׼
        if((CP2CLR << 2) == 0xfc)      //жϵ6λֵ
         return FAIL;                  //У׼ʧ
    }
    if((CP2CLR & 0X20) != 0X20)
     CP2CLR -= ENABLE;
    return PASS;                       //У׼ɹ
}
/************************************************
;  *    @            : CMP2_Init
;  *    @˵              : Ƚʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void CMP2_Init(void)
{
    CP2CLRE = DISABLE;                 //رCMP2ģʽ
    CPCR0 = DEF_SET_BIT2;              //ʹCMP2
    CPVR0 = 0x50;                      //˻׼ѹ0.5V*VDD
    P03OE = DISABLE;                   //P03
    P03DC = ENABLE;                    //P03ģ̬
    CPCR1 = 0x00;                      //ΪCP2N0 P03
    CP2NV = DISABLE;                   //CMP2Ϊƽ
    CPDB0 = 0xf0;                      //15ʱ
    CP2IE = ENABLE;                    //ʹCP2ж
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    while(CMP2_ADJ());                 //Ƚ2У׼
    CMP2_Init();                       //Ƚ2ʼ
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((CP2IF) && (CP2IE))
    {
        P06D  = !P06D;
        CP2IF = DISABLE;
    }
__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
