/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.04
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *               Ƚ3
;  *            15ʱ
;  *            ѡ0.5VDD
;  *            ѡⲿCP3N0 P05
;  *            ½شжP07ת
;  *            ʧѹ
;  *        ûѡǷҪеУ
***עCMP˿ڽֹգģѹΧ0-VDD-1.4
******************************************************************************/

#include "user.h"
/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : Delay
;  *    @˵              : ȷʱ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Delay(u16 num)
{
    for (i = 0; i < num; i ++)
    {
        Nop();
    }
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x03;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea
}
/************************************************
;  *    @            : CMP3_ADJ
;  *    @˵              :ȽУ׼
;  *    @          :
;  *    @ز          : 0 У׼ɹ  1У׼ʧ
;  ***********************************************/
uint8_t CMP3_ADJ(void)
{
    CPCR0   = DEF_SET_BIT3;            //CMP3ʹ
    CP3CLRE = ENABLE;                  //ʹCMP3ģʽ
    // CP1CLRS = 0;                       //ο
    CP3CLRS = ENABLE;                  //ο
    CPVR1 = 0x15;                      //˻׼ѹ0.5V*VDD
    CP3CLR &= 0xc0;                    //õ6λ=0
    Delay(200);                        //ʱ >100US
    CMPOF_FLAG = CP3OF;                //ȡֵ
    while(ENABLE)
    {
        CP3CLR++;   
        Delay(200);
        if(CP3OF != CMPOF_FLAG)        //жǷУ׼
         break;                        //У׼
        if((CP3CLR<<2)== 0xfc)         //жϵ6λֵ
         return FAIL;                  //У׼ʧ
    }
    if((CP3CLR & 0X20) != 0X20)
     CP3CLR -= ENABLE;
    return PASS;                       //У׼ɹ
}
/************************************************
;  *    @            : CMP3_Init
;  *    @˵              : Ƚʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void CMP3_Init(void)
{
    CP3CLRE = DISABLE;                 //رCMP3ģʽ
    P05OE = DISABLE;                   //P05
    P05DC = ENABLE;                    //P05ģ̬
    CPCR0 = DEF_SET_BIT3;              //ʹCMP3  ΪCP3N0 P05
    CP3NV = DISABLE;                   //CMP3Ϊƽ
    CPDB1 = 0x0f;                      //15ʱ
    CP3IE = ENABLE;                    //ʹCP3ж
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    while(CMP3_ADJ());                 //Ƚ3У׼
    CMP3_Init();                       //Ƚ3ʼ
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((CP3IF) && (CP3IE))
    {
        P07D  = !P07D;
        CP3IF = DISABLE;
    }
__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
