/******************************************************************************
;  *       @ͺ                 : MC32F7072
;  *       @             : 2023.02.07
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *               Ƚ4
;  *            15ʱ
;  *            ѡ0.5VDD
;  *            ѡⲿCP4N3 P10
;  *            ½شжP11ת
;  *            ʧѹ
;  *        ûѡǷҪеУ
***עCMP˿ڽֹգģѹΧ0-VDD-1.4
******************************************************************************/

#include "user.h"
/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : Delay
;  *    @˵              : ȷʱ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Delay(u16 num)
{
    for (i = 0; i < num; i ++)
    {
        Nop();
    }
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x03;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea
}
/************************************************
;  *    @            : CMP4_ADJ
;  *    @˵              :ȽУ׼
;  *    @          :
;  *    @ز          : 0 У׼ɹ  1У׼ʧ
;  ***********************************************/
uint8_t CMP4_ADJ(void)
{
    CPCR1 = DEF_SET_BIT4 | DEF_SET_BIT3 | DEF_SET_BIT2;//CMP4ʹ
    CP4CLRE = ENABLE;                  //ʹCMP4ģʽ
    // CP1CLRS = 0;                       //ο
    CP4CLRS = ENABLE;                  //ο
    CPVR1 = 0xE0;                      //˻׼ѹ0.5V*VDD
    CP4CLR &= 0xC0;                    //õ6λ=0
    Delay(200);                        //ʱ >100US
    CMPOF_FLAG = CP4OF;                //ȡֵ
    while(ENABLE)
    {
        CP4CLR++;   
        Delay(200);
        if(CP4OF != CMPOF_FLAG)        //жǷУ׼
         break;                        //У׼
        if((CP4CLR<<2)== 0xfc)         //жϵ6λֵ
         return FAIL;                  //У׼ʧ
    }
    if((CP4CLR & 0X20) != 0X20)
     CP4CLR -= ENABLE;
    return PASS;                       //У׼ɹ
}
/************************************************
;  *    @            : CMP4_Init
;  *    @˵              : Ƚʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void CMP4_Init(void)
{
    CP4CLRE = DISABLE;                 //رCMP4ģʽ
    P10OE = DISABLE;                   //P05
    P10DC = ENABLE;                    //P05ģ̬
    CPCR1 = DEF_SET_BIT4 | DEF_SET_BIT3 | DEF_SET_BIT2;//ʹCMP3  ΪCP4N3 P40
    CP4NV = DISABLE;                   //CMP4Ϊƽ
    CPDB1 = 0xF0;                      //15ʱ
    CP4IE = ENABLE;                    //ʹCP4ж
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    while(CMP4_ADJ());                 //Ƚ4У׼
    CMP4_Init();                       //Ƚ4ʼ
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((CP4IF) && (CP4IE))
    {
        P11D  = !P11D;
        CP4IF = DISABLE;
    }
__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
