/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.04
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                EEPROM
;  *                ȫռַд,ٶ;
;  *                ʱP03D                                            
******************************************************************************/

#include "user.h"

const uint16_t EEPROM_test_num[64] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
    40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
    50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
    60, 61, 62, 63};                   //д
uint16_t EEPROM_test_buff[64];         //Ի

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0 ++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x03;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea
}
/************************************************
;  *    @            : EEPROM_Write_Byte
;  *    @˵              : ڲEEPROMд2ֽ
;  *    @          : ַ  
;  *    @ز          : 
;  ***********************************************/
void EEPROM_Write_Byte(uint8_t addr, uint16_t data)
{
    HFEN = 1;
    EECR = 0x00;
    EEAR = addr;
    EEDRH = (data >> 8) & 0xff;
    EEDRL = data & 0xff;
    GIE = 0;
    ClrWdt();                          //忴Ź
    EEMASK = 0x5A;
    EEMASK = 0xA5;                     //
    EECR = 0xC0;                       //EEPROMд  дݲ
    Nop();
    GIE = 1;
}
/************************************************
;  *    @            : EEPROM_Read_Byte
;  *    @˵              : ڲEEPROM2ֽ
;  *    @          : ַ
;  *    @ز          : 
;  ***********************************************/
uint16_t EEPROM_Read_Byte(u8 addr)
{
    uint16_t EEDR;
    EEAR = addr;
    GIE = 0;
    EEMASK = 0x5A;
    EEMASK = 0xA5;    
    EECR = 0x80;                       // EE 
    Nop();
    GIE = 1;
    EEDR = (EEDRH << 8) | EEDRL;
    return EEDR;
}
/************************************************
;  *    @            : EEPROM_Write_Data
;  *    @˵              : д
;  *    @          : 
;  *    @ز          : 
;  ***********************************************/
void EEPROM_Write_Data(u8 addr, u16 *data, u8 len)
{
    while (len)
    {
        EEPROM_Write_Byte(addr ++, *data ++);
        len--;
    }
}
/************************************************
;  *    @            : EEPROM_Read_Write_Fill
;  *    @˵              : EEPROMȫռд
;  *    @          : 
;  *    @ز          : 
   *    ûѡöдռ  
;  ***********************************************/
void EEPROM_Read_Write_Fill(void)
{
    P03D = 0;
    P04D = 1;
    for(g_count2 = 0;g_count2 < 2;g_count2 ++)
    {
        EEPROM_Write_Data(0 + (g_count2 << 6), EEPROM_test_num, 64);                     //д
        for (g_count1 = 0; g_count1 < 64; g_count1 ++)
        {
            EEPROM_test_buff[g_count1] = EEPROM_Read_Byte(g_count1 + (g_count2 << 6));   //ȡ
            if(EEPROM_test_buff[g_count1] != EEPROM_test_num[g_count1])
            {
                P03D = 1;
                break;
            }
        }
    }
    P04D = 0;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    EEPROM_Read_Write_Fill();
    while (1)
    {
        ClrWdt();                      //忴Ź
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
