/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.31
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                    PPG
;  *        CMP0ΪƽP05 P04
;  *        CP0CP0_OUTźŵ½شPPGʼ
;  *        PPGP06ߣߵƽʱ䣺131us
;  *        PPGֹͣP06͵ƽ
;******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                    //ioλ
    OEP0 = 0xFF;                    //ioڷ 1:out  0:in
    PUP0 = 0x00;                    //io   1:SET  0:RESET
    PDP0 = 0x30;                    //io   1:SET  0:RESET
    P0ADCR = 0x00;                  //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                    //ioλ
    OEP1 = 0xFF;                    //ioڷ 1:out  0:in
    PUP1 = 0x00;                    //io   1:SET  0:RESET
    PDP1 = 0x00;                    //io   1:SET  0:RESET
    P1ADCR = 0x00;                  //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                    //ioλ
    OEP2 = 0x03;                    //ioڷ 1:out  0:in
    PUP2 = 0x00;                    //io   1:SET  0:RESET
    PDP2 = 0x00;                    //io   1:SET  0:RESETa
}

/************************************************
;  *    @            : Delay_100us
;  *    @˵              : ʧѹ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Delay(uint16_t num)
{
    uint16_t i;
    for (i = 0; i < num; i++)
    {
        Nop();
    }
}

/************************************************
;  *    @            : CMP0_ADJ
;  *    @˵              :ȽУ׼
;  *    @          :
;  *    @ز          : 0 У׼ɹ  1У׼ʧ
;  ***********************************************/
uint8_t CMP0_ADJ(void)
{
    CPCR0 = DEF_SET_BIT0;           //CMP0ʹ
    CP0CLRE = SET;                  //ʹCMP0ģʽ
    // CP0CLRS = RESET;                //ο
    CP0CLRS = SET;                  //ο
    CP0CLR &= 0xc0;                 //õ6λ=0
    Delay(200);                     //ʱ >100US
    CMPOF_FLAG = CP0OF;             //ȡֵ
    while(SET)
    {
        CP0CLR++;   
        Delay(200);
        if(CP0OF != CMPOF_FLAG)      //жǷУ׼
            break;                      //У׼
        if((CP0CLR << 2) == 0xfc)    //жϵ6λֵ
            return SET;                 //У׼ʧ
    }
    if((CP0CLR & 0X20) != 0X20)
        CP0CLR -= SET;
    return RESET;                    //У׼ɹ
}

/************************************************
;  *    @            : CMP0_Init
;  *    @˵              : Ƚʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void CMP0_Init(void)
{
    CP0CLRE = RESET;                //رCMP1ģʽ
    P05OE = RESET;                  //P05
    P05DC = SET;                    //P05ģ̬
    P04OE = RESET;                  //P04
    P04DC = SET;                    //P04ģ̬
    CPCR0 = DEF_SET_BIT0;           //ʹCMP0   P05 P04
    CP0NV = RESET;                  //CMP0Ϊƽ
}

/************************************************
;  *    @            : PPG_Init
;  *    @˵              : PPGʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void PPG_Init(void)
{
    PPGTIE = 1;  
    PPGTDB = 0x84;                  //ȽCP0Ϊź
    PPGLDH = 0x01;                  //3λؼĴ
    PPGLDL = 0x05;                  //8λؼĴ
    PPGTDL = 0x00;                  //ʱ ʱʱ0
    MEFCR = 0x18;                   //ڣP06PPGֹͣ˿ƽ
    PPGCR = 0xA3;                   //8Ƶ PPGʹܣ͵ƽPPGTLV(CMP0)PPGPPGļʱƵʱFcpu
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();                      //RAM
    IO_Init();                      //IOʼ
    while(CMP0_ADJ());              //ȽУ׼
    CMP0_Init();                    //Ƚʼ
    PPG_Init();                     //OPA
    GIE = 1;
}
void main()
{
    Sys_Init();
    while(1)
    {
   	   	Nop();
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if(PPGTIF)
    {
        PPGTIF = 0;
    }
__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}