/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.04
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                Time2ģʽ
;  *          TC2(P00) 1ڵĵ͵ƽ
;  *          ½ؿʼֹͣT2ENԶ0
;  *          ͨT2CNTݼļֵɻñⲶƽȴT2CNT_num
;  *          ⲶʱΪT2CNT_num*1us
;  *          Ҫٴβɼ¸ֵT2LOAD 200us¿ʱ T2
;  *          עڲ200usڵĵ͵ƽ壬ʱ䳬Χ޸T2ʱڲɹۼӼ
******************************************************************************/

#include "user.h"

u8 T2CNT_num;       //Ⲷƽ

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFE;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x03;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea
}
/************************************************
;  *    @            : TIMER2_INT_Init
;  *    @˵              : ʱ2ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER2_INT_Init(void)//Fcpu,8Ƶ,ģʽ
{
    T2CR = DEF_SET_BIT6 | DEF_SET_BIT1 | DEF_SET_BIT0;
    T2CNT = 200 - 1;
    T2LOAD = 200 - 1;           //200us
    T2EFR = 0x40;               // T2PIF1 TC2 1ڵĵ͵ƽ
    T2EN = 1;                   //ʱ T2
    T2PIE = 1;                  //T2׽жʹ
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER2_INT_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    T2CNT_num=0;
    while (1)
    {
        if(T2PIF_flag)                      //ɹ
        {
            T2PIF_flag = RESET;
            T2CNT_num = T2LOAD-T2CNT;       //Ⲷƽ
            Nop();
            // T2LOAD = 200 - 1;               //Ҫٴβɼ¸ֵT2LOAD 200us
            // T2EN = 1;                       //Ҫٴβɼ¿ʱ T2
        }
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if (T2PIF & T2PIE)
    {
        P03D = !P03D;
        T2PIF_flag = SET;                   //ɹ
        T2PIF = 0;
    }
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
