/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.31
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *               T3 PPGģʽ
;  *            P030ʼ
;  *            PPGڣP06Ÿߵƽʱ䣺128us
;  *            PPGֹͣ󣬶˿ƽ
;  *            PPG תΪֹͣʱT3ʼ 200uS P07ȡһ
;  *            P12P14Ϊ̶˿
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                    //ioλ
    OEP0 = 0xF7;                    //ioڷ 1:out  0:in
    PUP0 = 0x08;                    //io   1:enable  0:disable
    PDP0 = 0x00;                    //io   1:enable  0:disable
    P0ADCR = 0x00;                  //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                    //ioλ
    OEP1 = 0xFF;                    //ioڷ 1:out  0:in
    PUP1 = 0x00;                    //io   1:enable  0:disable
    PDP1 = 0x00;                    //io   1:enable  0:disable
    P1ADCR = 0x00;                  //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                    //ioλ
    OEP2 = 0x03;                    //ioڷ 1:out  0:in
    PUP2 = 0x00;                    //io   1:enable  0:disable
    PDP2 = 0x00;                    //io   1:enable  0:disablea
}

/************************************************
;  *    @            : Delay_us
;  *    @˵              : ʱ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Delay_us(uint16_t num)
{
    uint16_t i;
    for (i = 0; i < num; i++)
    {
        Nop();
    }
}

/************************************************
;  *    @            : PPG_Init
;  *    @˵              : PPGʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void PPG_Init(void)
{
    // PPGTIE = 1;  
    // PPGTDB = 0x84;                  //ȽCP0Ϊź
    // PPGLDH = 0x01;                  //3λؼĴ
    // PPGLDL = 0x05;                  //8λؼĴ
    // PPGTDL = 0x00;                  //ʱ ʱʱ0
    // MEFCR = 0x18;                   //ڣP06PPGֹͣ˿ƽ
    // PPGCR = 0xA1;                   //8Ƶ PPGʹܣ͵ƽPPGTLV(CMP0)PPGPPGļʱƵʱFcpu

    PPGCR = 0x01;
    PPGLDH = 0x07;                  //3λؼĴ
    PPGLDL = 0xFF;                  //8λؼĴ
    MEFCR = 0x18;                   //ڣP06PPGֹͣ˿ƽ
}

/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱ0ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR =  0x4D;           //Hirc,32Ƶ
    T0CNT = 100 - 1;
    T0LOAD = 100 - 1;       //100us
    T0DATA = 50;
    PWM0OE = 1;
    T0IE = 1;
}

/************************************************
;  *    @            : TIMER3_INT_Init
;  *    @˵              : ʱ3ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER3_INT_Init(void)
{
    T3CR =  0x4F;           //Hirc,32Ƶζʱģʽ
    T3CNT = 50 - 1;
    T3LOAD = 50 - 1;        //200us
    T3IE = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();                      //RAM
    IO_Init();                      //IOʼ
    PPG_Init();                     //OPA
    TIMER0_INT_Init();
    TIMER3_INT_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if(P03D == 0)
        {
            T0EN = 1;
            T3EN = 1;
            PPGEN = 1;
        }
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    //=======T0========================
    if (T0IF & T0IE)
    {
        T0IF = 0;
        PPGSTR = 1;         //PPG
   	   	P05D =! P05D;
    }
    //=======T3========================
    if (T3IF & T3IE)
    {
        P07D = !P07D;
        T3IF = 0;
    }
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/