/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.04
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                Ƚ0
;  *                ˿Ϊģ̬
;  *                P05     P04
;  *                ˸ڸP03Ϊߣ֮P03Ϊ
;  *                ʧѹûѡǷҪеУ
;  *            ***עCMP˿ڽֹգģѹΧ0-VDD-1.4***
******************************************************************************/

#include "user.h"
/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}
/************************************************
;  *    @            : Delay
;  *    @˵              : ȷʱ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Delay(u16 num)
{
    for (i = 0; i < num; i ++)
    {
        Nop();
    }
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x03;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea
}
/************************************************
;  *    @            : CMP0_ADJ
;  *    @˵              :ȽУ׼
;  *    @          :
;  *    @ز          : 0 У׼ɹ  1У׼ʧ
;  ***********************************************/
uint8_t CMP0_ADJ(void)
{
    CPCR0 = DEF_SET_BIT0;              //CMP0ʹ
    CP0CLRE = ENABLE;                  //ʹCMP0ģʽ
    // CP0CLRS = DISABLE;                //ο
    CP0CLRS = ENABLE;                  //ο
    CP0CLR &= 0xc0;                    //õ6λ=0
    Delay(200);                        //ʱ >100US
    CMPOF_FLAG = CP0OF;                //ȡֵ
    while(ENABLE)
    {
        CP0CLR++;   
        Delay(200);
        if(CP0OF != CMPOF_FLAG)        //жǷУ׼
         break;                        //У׼
        if((CP0CLR << 2) == 0xfc)      //жϵ6λֵ
         return FAIL;                  //У׼ʧ
    }
    if((CP0CLR & 0X20) != 0X20)
     CP0CLR -= ENABLE;
    return PASS;                    //У׼ɹ
}

/************************************************
;  *    @            : CMP0_Init
;  *    @˵              : Ƚʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void CMP0_Init(void)
{
    CP0CLRE = DISABLE;                 //رCMP1ģʽ
    P05OE = DISABLE;                   //P05
    P05DC = ENABLE;                    //P05ģ̬
    P04OE = DISABLE;                   //P04
    P04DC = ENABLE;                    //P04ģ̬
    CPCR0 = DEF_SET_BIT0;              //ʹCMP0   P05 P04
    CP0NV = DISABLE;                   //CMP0Ϊƽ
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    while(CMP0_ADJ());                 //ȽУ׼
    CMP0_Init();                       //Ƚʼ
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if(CP0OF)
            P03D = ENABLE;               //˸ڸ  P03Ϊ
        else
            P03D = DISABLE;              //˵ڸ  P03Ϊ
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
