/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.04
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *            ΪMC32F7132_IIC_Slave(Ӳӻ)
;  *            ȴӻϵϵ
;  *            ͨѶַ0x40  MC32F7132_IIC_Slave(Ӳӻ)MC32F7132_IIC_Master(ģ)ͨѶ
;  *            յʼźź
;  *            1(20byte)Ȼԭ(20byte,0x40ַ)
;  *            ͺͽһ£P13DΪ;֮P13DΪ
;  *            ʹPDT1(P12)PCK1(P14)Կ
******************************************************************************/
#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0 ++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @          : Delay
;  *    @˵            : ȷʱ
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void Delay(u16 num)
{
    while(num)
    {
        Nop();
        Nop();
        Nop();
        Nop();
        num--;
    }
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x05;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x03;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea
}
/************************************************
;  *    @            : IIC_Init
;  *    @˵              : IICʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IIC_Init(void)
{
    IICAR = 0x40;                      //IICַ
    IICEN = 1;                         //ʹIIC
    IICIE = 1;                         //ʹIICж
}
/************************************************
;  *    @            : IIC_Init
;  *    @˵              : IICʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IIC_Start(void)
{
    IICMOD = 0;                         //ģʽյַͶ/дλ
    while(FLAG_IIC_DONE == 0);          //˳ж
    FLAG_IIC_DONE = 0;
    if(FLAG_IIC_START == 1)             //ַƥ
    {
        FLAG_IIC_START = 0;
        
        if(MSTCMD == 1)                 //Ͷź
        {
            IICMOD = 1;                 //ӻ
            FLAG_Write = 1;
            IICDR = g_iic_buff[0];      //0
            while(FLAG_IIC_DONE == 0);
            FLAG_IIC_DONE = 0;
        }
        if(MSTCMD == 0)                 //дź
        {
            IICMOD = 0;                 //ӻ͵
            FLAG_Recive = 1;
        }
    }
}
/************************************************
;  *    @            : IIC_Write_Byte
;  *    @˵              : IICӻ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IIC_Write_Byte(void)
{
    IIC_Start();
    if(FLAG_Write == 1)
    {
        FLAG_Write = 0;
        for(num=1;num<20;num++)
        {
            if( RACK == 0)
            {
                IICDR = g_iic_buff[num];
                while(FLAG_IIC_DONE == 0);      //ȴIICж
                FLAG_IIC_DONE = 0;
            }
        }
    }
}
/************************************************
;  *    @            : IIC_Recive_Byte
;  *    @˵              : IICӻȡһֽ
;  *    @          :
;  *    @ز          : temp-ǰȡ
;  ***********************************************/
u8 IIC_Recive_Byte(void)
{
    a++;
    IICMOD = 0;
    while(FLAG_IIC_DONE == 0);                  //ȴIICж
    FLAG_IIC_DONE = 0;
    temp = IICDR;
    if(a<20)
        SACK = 0;
    else
        SACK = 1;
    return temp;
}
/************************************************
;  *    @            : IIC_Read_Len_Byte
;  *    @˵              : IICӻȡ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IIC_Read_Len_Byte(u8 *data,u8 len)
{
    IIC_Start();
    if(FLAG_Recive == 1)
    {
        FLAG_Recive = 0;
        while(len)
        {
            *data = IIC_Recive_Byte();
            data++;
            len--;
            Delay(100);
        }
    }
}
/************************************************
;  *    @            : Data_Comparison
;  *    @˵              : ͺͶȡݶԱ
;  *    @          : ͳ
;  *    @ز          : FAIL OR PASS
;  ***********************************************/
u8 Data_Comparison(u8 *data1,u8 *data2,u8 len)
{
    while(len)
    {
        if(*data1!=*data2)
            return FAIL;    //ݴ
        len--;
        data1++;
        data2++;
    }
    return PASS;            //ȷ
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    IIC_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();             //ʼ
    IIC_Write_Byte();       //д20byte
    IIC_Read_Len_Byte(g_iic_buff_data,IIC_DATA_LEN);                //20byteݴ0x40ַ
    while (1)
    {
        if(Data_Comparison(g_iic_buff,g_iic_buff_data,IIC_DATA_LEN))//ждǷһ
        {
            P13D=1;
        }
        else 
            P13D=0;
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

    if(IICIF)
    {
        IICIF  = 0;
        FLAG_IIC_DONE=1;
        if(IICAAS)          //жϵַǷһ
        {
            FLAG_IIC_START=1;
            SACK = 0;
        }
    }
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/