/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.04
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                   SLEEP
;  *                   1sģʽP03͵ƽ
;  *                   P15ⲿжϻѣP03ߵƽ                               
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xDF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x0F;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱ0ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT2 | DEF_SET_BIT0;//CPU,32Ƶ
    T0CNT = 250-1;
    T0LOAD = 250-1;                    //1ms
    T0EN = 1;
    T0IE = 1;
}
/************************************************
;  *    @            : INT_Init
;  *    @˵              : ⲿжϳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void INT_Init(void)
{
    /*************INT0**************/  
    MCR |= DEF_SET_BIT0;                    //INI0½ش
    PUP1 |= DEF_SET_BIT5;                   //
    OEP1 &= DEF_CLR_BIT5;                   //in
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    INT_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if (FLAG_TIMER0_1000MS)
        {
            FLAG_TIMER0_1000MS = 0;
            GIE = 0;
            INT0IF = 0; 
            INT0IE = 1;                             //ⲿжʹ
            //ǰر AD ʹܻⲿж
            P03D = 0;
            Nop();
            Nop();
            Stop();
            Nop();
            Nop();
            INT0IF = 0; 
            INT0IE = 0;                             //رⲿж
            GIE = 1;
            //ѺʹرⲿжϣʵӦû
            P03D=1;
        }
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    //=======T0========================
    if (T0IF & T0IE)
    {
        T0IF = 0;
        g_timer0_num++;
        if (g_timer0_num >= 1000)        //1s
        {
            g_timer0_num = 0;
            FLAG_TIMER0_1000MS = 1;
        }
    }
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
