/******************************************************************************
;  *       @ͺ                 : MC30P6310
;  *       @             : 2023.01.19
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                    ˣEVN1ѹ P15 
                        ˣVIR 0.5V
                        P15>3.5V  CMPOF=0       P11
                        P15<3.5V  CMPOF=1       P11 
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    __asm 
    movai 0x40 
    movra FSR
    movai 48 
    movra 0x07 
    decr FSR
    clrr INDF
    djzr 0x07 
    goto $ -3;
    clrr 0x07 
    __endasm;
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    P1 = 0x00;               //IOλ
    DDR1 = 0x20;             //IOڷ 1:input 0:output P15D
    PUCON = 0xFF;            //IO 0:Effective 1:invalid
    PDCON = 0xFF;            //IO 0:Effective 1:invalid
    P1ADCR = 0x00;           //IOֹ 0:Effective 1:invalid
    ODCON = 0x00;            //0:  1:©
}

/************************************************
;  *    @            : CMP_Init
;  *    @˵              : Ƚʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void CMP_Init(void)
{
    P1ADCR = 0x20;      //رP15Dֹ
    CMPCR0 = 0x94;      //CMP  VIR VDDѹ ֹCMP˿ 
    CMPCR1 = 0x2A;      //ֵ3.5V
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    CMP_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if(CMPOF)       //EVN1<3.5V
        {
            P11D = 1;
        }
        else 
        {
            P11D = 0;
        }
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _STATUS
    movra _statusbuf
    __endasm;

    __asm 
    swapar _statusbuf
    movra _STATUS
    swapr _abuf
    swapar _abuf
    __endasm;
}


/**************************** end of file *********************************************/