/******************************************************************************
;  *       @ͺ                 : MC30P6310
;  *       @             : 2023.01.19
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                            ˣVDDѹ   VDD=5V   EVDVS=0x0D(ѹ204);  
                                㣺(204*5)/600=1.7V
                                ˣEVN0 P14D
                                EVN0>1.7V  P12D  ֮
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    __asm 
    movai 0x40 
    movra FSR
    movai 48 
    movra 0x07 
    decr FSR
    clrr INDF
    djzr 0x07 
    goto $ -3;
    clrr 0x07 
    __endasm;
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    P1 = 0x00;               //IOλ
    DDR1 = 0x10;             //IOڷ 1:input 0:output,P14D
    PUCON = 0xFF;            //IO 0:Effective 1:invalid
    PDCON = 0xFF;            //IO 0:Effective 1:invalid
    P1ADCR = 0x00;           //IOֹ 0:Effective 1:invalid
    ODCON = 0x00;            //0:  1:©
}

/************************************************
;  *    @            : CMP_Init
;  *    @˵              : Ƚʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void CMP_Init(void)
{
    P1ADCR = 0x10;        //رP14D(EVN0)ֹ
    CMPCR0 = 0xC5;        //EVN0 VDDѹ  CMPOƽ 
    CMPCR1 = 0x0D;        //ѹ204
    CMPCR2 = 0x00;        //رж
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    CMP_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _STATUS
    movra _statusbuf
    __endasm;

    __asm 
    swapar _statusbuf
    movra _STATUS
    swapr _abuf
    swapar _abuf
    __endasm;
}


/**************************** end of file *********************************************/