/******************************************************************************
;  *       @ͺ                 : MC32F7062
;  *       @             : 2023.3.14
;  *       @˾/            : ΢-AE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 :΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *    RAMROMȫռ
;  *    RAM:ȫռд,ȡΪдֵʱ,SUCCESS;
;  *    ROM:CRC16ȫռȡУ,УֵEEPROMԤ¼ֵԱ,һ򷵻SUCCESS;
;  *    RAMROMʱ,ռòʱ,ϸʱɲ鿴Ӧ˵;
***************************** *************************************************/

#include "user.h"
#include "ROM_CHECK.h"

u8 abuf;
u8 statusbuf;

uint8_t rom_value_H;
uint8_t rom_value_L;
uint16_t ee_crc_value;
uint16_t rom_addr_count;
uint16_t CRC;


/*õַΪRAMַ,RAMROMУ,Ҫ޸.*/
extern volatile bit_flag __at 0xFF flag1;
/**/
volatile bit_flag flag2;
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;

    OEP0 = 0xff;
    OEP1 = 0xff;
    OEP2 = 0xff;

    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;

    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
}

/************************************************
;  *    @            : GET_EEcrc_Value
;  *    @˵              : EEPROMַݶȡ(Уֵ)
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void GET_EEcrc_Value() {
    EEAR = EEPROM_LSB;
    EECR = 0x02;        // EE 
    while(EEREAD) {     // EE дǷ
    }
    ee_crc_value = (uint16_t)(EEDR << 8);
    EEAR = EEPROM_MSB;
    EECR = 0x02;
    while(EEREAD) {
    }
    ee_crc_value += EEDR;
}

/************************************************
;  *    @          : ROM_Check_allspace
;  *    @˵            : ROMȫռCRCУ,0x00~0xFFF
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void ROM_Check_allspace() {
    CRC = 0xFFFF;
    for(rom_addr_count=0;rom_addr_count<0x1000;rom_addr_count++) {
        FSR1 = (uint8_t)(rom_addr_count >> 8);
        FSR0 = (uint8_t)rom_addr_count;
        rom_value_L = INDF3;
        rom_value_H = HIBYTE;
        CRC = ROM_CRC16(rom_value_H,rom_value_L,CRC);
    }
}

/************************************************
;  *    @          : ROM_Check
;  *    @˵            : УУȽ
;  *    @        :
;  *    @ز        :
;  ***********************************************/
uint8_t ROM_Check() {
    ROM_Check_allspace();         //ROMȫռУ
    GET_EEcrc_Value();            //ⲿУֵȡ
    if(CRC == ee_crc_value) {
        return SUCCESS;
    }
    else {
        return ERROR;
    }
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    IO_Init();          //IOʼ
    CLR_RAM_one();      //ʼRAM
    RAM_Check();
    CLR_RAM_two();      //УɺٴRAM
    FLAG_ROM_CHECK = ROM_Check();      //ROMУ
    GIE = 1;
}
void main(void)
{
    Sys_Init();
    if(FLAG_RAM_CHECK == 1) {
        P02D = 1;            //RAM check success
    }
    if(FLAG_ROM_CHECK) {
        P03D = 1;            //ROM check success
    }
    while (1)
    {
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((T0IF) && (T0IE))
    {
        T0IF = 0;
    }

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
