/******************************************************************************
;  *       @ͺ                 : MC32F7062
;  *       @             : 2023.3.14
;  *       @˾/            : ΢-AE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 :΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *          
******************************************************************************/
#include "user.h"

extern uint16_t ee_crc_value;


volatile bit_flag __at 0xFF flag1;
/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM_one(void) {
    for (FSR0 = 0; FSR0 < RAM_END_ADDR; FSR0++)
    {
        INDF0 = RESET_INDF0;
    }
    FSR0 = RAM_END_ADDR;
    INDF0 = RESET_INDF0;
}

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM_two(void) {
    for (FSR0 = 1; FSR0 < RAM_END_ADDR; FSR0++)
    {
        INDF0 = RESET_INDF0;
    }
    // FSR0 = RAM_END_ADDR;    //βַ,У
    // INDF0 = RESET_INDF0;
}

/************************************************
;  *    @          : RAM_Write_one
;  *    @˵            : RAMȫռλ
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void RAM_Write_value(uint8_t data) {
    for (FSR0 = 0; FSR0 < RAM_END_ADDR; FSR0++)
    {
        INDF0 = data;
    }
    FSR0 = RAM_END_ADDR;
    INDF0 = data;
}

/************************************************
;  *    @          : RAM_Check_allspace
;  *    @˵            : RAMȫռ,0x00~0xFF
;  *    @        :
;  *    @ز        :
;  ***********************************************/
uint8_t RAM_Check_allspace(uint8_t value) {
    RAM_Write_value(value);       // ȫռдֵ
    for (FSR0 = 0; FSR0 < RAM_END_ADDR; FSR0++) {
        if(INDF0 != value) {
            return ERROR;
        }
    }
    FSR0 = RAM_END_ADDR;
    if(INDF0 != value) {
        return ERROR;
    }
    else {
        FSR0 = 0xFF;
        INDF0 = 0x00;
        return SUCCESS;
    }
}

/************************************************
;  *    @          : RAM_Check
;  *    @˵            : RAMַȫռд0xA50x5A
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void RAM_Check() {
    FLAG_RAM_CHECK = RAM_Check_allspace(0xA5);
    if(FLAG_RAM_CHECK == SUCCESS) {              //ֻе0xA5ԳɹŻ0x5AĲ
        FLAG_RAM_CHECK = RAM_Check_allspace(0x5A);
    }
}

