/******************************************************************************
;  *       @ͺ                 : MC32F7062
;  *       @             : 2023.3.14
;  *       @˾/            : ΢-AE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 :΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                   ʱʹȫֱ                       
******************************************************************************/
#ifndef USER
#define USER

#include "mc32-common.h"
#include "mc32F7062.h"

#define u8 unsigned char
#define u16 unsigned int
#define u32 unsigned long int
#define uint8_t  unsigned char
#define uint16_t unsigned int
#define uint32_t unsigned long int

#define DEF_SET_BIT0           0x01
#define DEF_SET_BIT1           0x02
#define DEF_SET_BIT2           0x04
#define DEF_SET_BIT3           0x08
#define DEF_SET_BIT4           0x10
#define DEF_SET_BIT5           0x20
#define DEF_SET_BIT6           0x40
#define DEF_SET_BIT7           0x80

#define DEF_CLR_BIT0           0xFE
#define DEF_CLR_BIT1           0xFD
#define DEF_CLR_BIT2           0xFB
#define DEF_CLR_BIT3           0xF7
#define DEF_CLR_BIT4           0xEF
#define DEF_CLR_BIT5           0xDF
#define DEF_CLR_BIT6           0xBF
#define DEF_CLR_BIT7           0x7F

#define ENABLE                 1
#define DISABLE                0

#define FAIL                   1
#define PASS                   0

#define SUCCESS                1
#define ERROR                  0

#define SET_INDF0              0xFF
#define RESET_INDF0            0

#define RAM_END_ADDR           0xFF
#define ROM_END_ADDR           0xFFF

#define CRC_16_POLYNOMIALS     0x8005

#define EEPROM_MSB             0x01
#define EEPROM_LSB             0x00

void IO_Init(void);
void Sys_Init(void);

void CLR_RAM_one(void);
void CLR_RAM_two(void);
void RAM_Write_value(uint8_t data);
uint8_t RAM_Check_allspace(uint8_t value);
void RAM_Check();

void GET_EEcrc_Value();
uint8_t ROM_Check();


//===============Define  Flag===============
typedef union {
       unsigned char byte;
       struct
       {
              u8 bit0 : 1;
              u8 bit1 : 1;
              u8 bit2 : 1;
              u8 bit3 : 1;
              u8 bit4 : 1;
              u8 bit5 : 1;
              u8 bit6 : 1;
              u8 bit7 : 1;
       } bits;
}bit_flag;
extern volatile bit_flag __at 0xFF flag1;
extern volatile bit_flag flag2;
#define      FLAG_RAM_CHECK       flag1.bits.bit0
#define      FLAG_ROM_CHECK       flag1.bits.bit1
#define      timer_uart_flag      flag1.bits.bit2
#define      send_end_flag        flag1.bits.bit3

#endif

/**************************** end of file *********************************************/