/******************************************************************************
;  *       @ͺ                 : MC32F7073
;  *       @             : 2023.03.07
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                      EEPROM
;  *                EEPROMд,ٶ;
;  *                UARTӡݣ0xA5ͷ 0x5Aβ
;  *                עڣTX0(P11) RX0(P10) 4800
******************************************************************************/

#include "user.h"

const uint16_t EEPROM_test_num[18] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    10, 11, 12, 13, 14, 15, 16, 17};   //д
uint16_t EEPROM_test_buff[18];         //Ի

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in 
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable
    
    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in 
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable
    
    IOP2 = 0x00;             //ioλ
    OEP2 = 0xFF;             //ioڷ 1:out  0:in
    PUP2 = 0x00;             //io   1:enable  0:disable
    PDP2 = 0x00;             //io   1:enable  0:disable

    ADIOS0 = 0x00;           //ioѡ  1:ģ  0:ͨio
    ADIOS1 = 0x00;           //ioѡ  1:ģ  0:ͨio
}

/************************************************
;  *    @            : EEPROM_Write_Byte
;  *    @˵              : ڲEEPROMд1ֽ
;  *    @          : ַ  
;  *    @ز          : 
;  ***********************************************/
void EEPROM_Write_Byte(uint8_t addr, uint16_t data)
{
    HFEN = 1;                     //ȷƵ
    EECR = 0x00;                  //EETRIG
    EEAR = addr;
    EEDRH = (data >> 8) & 0xFF;
    EEDRL = data & 0xFF;
    GIE = 0;
    EEPR = 0x5A;
    EEPR = 0xA5;                  //
    EECR = 0xC0;                  //EEPROMд  дݲ
    Nop();
    Nop();
    while(EETRIG)                // EE дǷ
    {
        ClrWdt();                 //忴Ź
    }
    GIE = 1;
}

/************************************************
;  *    @            : EEPROM_Read_Byte
;  *    @˵              : ڲEEPROM1ֽ
;  *    @          : ַ
;  *    @ز          : 
;  ***********************************************/
uint16_t EEPROM_Read_Byte(u8 addr)
{
    HFEN = 1;                     //ȷƵ
    EECR = 0x00;                  //EETRIG
    EEAR = addr;
    GIE = 0;
    EEPR = 0x5A;
    EEPR = 0xA5;                  //
    EECR = 0x80;                  // EE 
    Nop();
    Nop();
    while(EETRIG)                 // EE дǷ
    {
        ClrWdt();                 //忴Ź
    }
    GIE = 1;
    EE_READ = (EEDRH << 8) | EEDRL;
    return EE_READ;
}

/************************************************
;  *    @            : EEPROM_Write_Data
;  *    @˵              : д
;  *    @          : 
;  *    @ز          : 
;  ***********************************************/
void EEPROM_Write_Data(u8 addr, u16 *data, u8 len)
{
    while (len)
    {
        EEPROM_Write_Byte(addr ++, *data ++);
        len--;
    }
}

/************************************************
;  *    @            : UART_Init
;  *    @˵              :   IO
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void UART_Init(void)
{
    IOP1 |= 0x02;            //IOĬϸ
    P10OE = 0;               //P10in
    P10PU = 1;               //P10up

    T2CR = 0x80;             //FCPU   Ƶ 
    T2LOADH = 0x00;
    T2LOADL = 51;            //Baud=FT2/(16*(T2LOAD+1))  4800

    SCON = 0x54;             //ʽ1
    UARTIE = 1;
}

/************************************************
;  *    @            : UART_Send_Byte
;  *    @˵              : 
;  *    @          : 
;  *    @ز          :
;  ***********************************************/
void UART_Send_Byte(u8 dat)
{
    REN = 0;            //ֹ
    UARTIE = 0;         //رжʹ
    SBUF = dat;         //дݵUARTݼĴ
    while (!TI);        //ȴǰݷ
    TI = 0;
    REN = 1;            //ʹܽ Ҫݿ
    UARTIE = 1;         //ҪUARTжϿ
}

/************************************************
;  *    @            : EEPROM_Read_Write_Fill
;  *    @˵              : EEPROMȫռд
;  *    @          : 
;  *    @ز          : 
   *    ûѡöдռ  
;  ***********************************************/
void EEPROM_Read_Write_Fill(void)
{
    EEPROM_Write_Data(0 , EEPROM_test_num, 18);                      //д
    UART_Send_Byte(0xA5);
    for (g_count1 = 0; g_count1 < 18; g_count1 ++)
    {
        EEPROM_test_buff[g_count1] = EEPROM_Read_Byte(g_count1);     //ȡ
        UART_Send_Byte(EEPROM_test_buff[g_count1]);
    }
    UART_Send_Byte(0x5A);
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    UART_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    EEPROM_Read_Write_Fill();
    while (1)
    {
        ClrWdt();                      //忴Ź
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}
