/******************************************************************************
;  *       @型号                 : MC32P7051
;  *       @创建日期             : 2024.1.25
;  *       @公司/作者            : 晟矽微电-FAE
;  *       @晟矽微官网           : http://www.sinomcu.com/
;  *       @版权                 : 2024 晟矽微电公司版权所有.
;  *----------------------摘要描述---------------------------------
;  *                      定时唤醒
;  *               T1(时钟内部32K)1S溢出唤醒       P11翻转
******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : 清RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0x7F;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0x7F;
    INDF0 = 0x00;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IO初始化
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //io口数据位
    OEP0 = 0xFF;             //io口方向 1:out  0:in
    PUP0 = 0x00;             //io口上拉电阻   1:enable  0:disable
    PDP0 = 0x00;             //io口上拉电阻   1:enable  0:disable

    IOP1 = 0x00;             //io口数据位
    OEP1 = 0xFF;             //io口方向 1:out  0:in   
    PUP1 = 0x00;             //io口上拉电阻   1:enable  0:disable
    PDP1 = 0x00;             //io口上拉电阻   1:enable  0:disable

    P0ADCR = 0x00;           //io口数字功能 1:disable  0:enable
    P0ADCR = 0x00;           //io口数字功能 1:disable  0:enable
    PMOD = 0x00;             //P13D推挽输出
}

/************************************************
;  *    @Function Name       : TIMER1_INT_Init
;  *    @Description         : T1初始化
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = DEF_SET_BIT0 | DEF_SET_BIT1 | DEF_SET_BIT2 | DEF_SET_BIT4;//内部低频,128频
    T1LOAD = 250-1;
    T1CNT = 250-1;
    T1EN = 1;
    T1IE = 1;
}

/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : 系统初始化
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER1_INT_Init();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 主函数
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    HFEN=0;
    LFEN=1;                            //关闭高频,内部低频始终工作
    while (1)
    {
        Nop();
        Nop();
        Stop();
        Nop();
        Nop();
        P11D =! P11D;
    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : 中断函数
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _PFLAG
    movra _statusbuf
    __endasm;
    //=======T1========================
    if (T1IF & T1IE)
    {
        T1IF = 0;
    }
    __asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
    __endasm;
}

/**************************** end of file *********************************************/
