/******************************************************************************
;  *       @ͺ                 : MC32P7051
;  *       @             : 2024.1.25
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2024 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                      ʱ
;  *                T0   P10 100uSת
;  *                T1   P11 1mSת
;  *                T2   P12 1Sת
******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0x7F;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0x7F;
    INDF0 = 0x00;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable

    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in   
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable

    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    PMOD = 0x00;             //P13D
}

/************************************************
;  *    @Function Name       : TIMER0_INT_Init
;  *    @Description         : T0ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = 0x83;             //ʱΪCPUʱ    ʱ8Ƶ  100us
    T0LOAD = 100-1;
    T0CNT = 100-1;
    T0IE = 1;
}

/************************************************
;  *    @Function Name       : TIMER1_INT_Init
;  *    @Description         : T1ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = 0x85;             //ʱΪCPUʱ    ʱ32Ƶ  1ms
    T1LOAD = 250-1;
    T1CNT = 250-1;
    T1IE = 1;
}

/************************************************
;  *    @Function Name       : TIMER2_INT_Init
;  *    @Description         : T2ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER2_INT_Init(void)
{
    T2CR = 0x86;             //ʱΪCPUʱ    ʱ64Ƶ 2ms
    T2LOAD = 250-1;
    T2CNT = 250-1;
    T2IE = 1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    TIMER1_INT_Init();
    TIMER2_INT_Init();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {

    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _PFLAG
    movra _statusbuf
    __endasm;


    //=======T0========================
    if (T0IF & T0IE)
    {
        P10D = !P10D;
        T0IF = 0;
    }
    //=======T1========================
    if (T1IF & T1IE)
    {
        P11D = !P11D;
        T1IF = 0;
    }
    //=======T2========================
    if (T2IF & T2IE)
    {
        P12D = !P12D;
        T2IF = 0;
    }
    __asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
    __endasm;
}

/**************************** end of file *********************************************/
