/******************************************************************************
;  *       @ͺ                 : MC32P7051
;  *       @             : 2024.1.25
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2024 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                  ADC 
;  *                  ϵУ׼
;  *                  ADCʱΪHIRC16Ƶ1M12λH8L4ڲ2V15ADCLK
;  *                  ʱ5SP15 ɼѹֵ 
;  *                  ģ⴮ڴӡADֵ4800 TX-P10D
******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0x7F;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0x7F;
    INDF0 = 0x00;
}
/************************************************
;  *    @Function Name       : delay
;  *    @Description         : ȷʱ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void delay(uint16_t num)
{
    for (i = 0; i < num; i ++)
    {
        Nop();
    }
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable

    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in   
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable

    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    PMOD = 0x00;             //P13D
}

/************************************************
;  *    @Function Name       : TIMER0_INT_Init
;  *    @Description         : 
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR |= DEF_SET_BIT2;       //CPU,16Ƶ
}

/************************************************
;  *    @Function Name       : TIMER1_INT_Init
;  *    @Description         : T1ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = 0x85;             //ʱΪCPUʱ    ʱ16Ƶ  1ms
    T1LOAD = 250-1;
    T1CNT = 250-1;
    T1IE = 1;
}

/************************************************
;  *    @Function Name       : UART_TX_Value
;  *    @Description         : UART
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void UART_TX_Value(u8 data)
{
    Uart_TX_flag = 1;
    UART_TX_Num = data;
    T0CNT = 104;
    T0LOAD = 104;
    T0EN = 1;
    T0IE = 1;
    while(Uart_TX_flag);    //ȴ
}

/************************************************
;  *    @Function Name       : ADC_Zero_ADJ
;  *    @Description         : ADCУ׼
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 0 У׼ɹ  1У׼ʧ
;  ***********************************************/
uint8_t ADC_Zero_ADJ(void)
{
    ADCR0 = 0xEF;                                //ʹADC16ƵGNDͨ
    ADCR1 = 0x30;                                //84ڲ2V1
    OSADJCR |= DEF_SET_BIT7;                     //ʹУ׼޵
    ADEOC = 0;
    while (!ADEOC);
    if ((ADRH == 0) && ((ADRL & 0x0F) == 0))     //ǷΪ0
    {
        OSADJTD = 1;                             //޵
        OSADJCR |= 0x3F;
        ADEOC = 0;
        while (!ADEOC);
        if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) //ǷΪ0
        {
            ADEN = 0;
            return PASS;
        }
        else
        {
            while (1)
            {
                if (OSADJCR & 0x3f)
                {
                    OSADJCR --;
                    ADEOC = 0;
                    while (!ADEOC);
                    if ((ADRH == 0) && ((ADRL & 0x0F) == 0))//ǷΪ0
                    {
                        ADEN = 0;
                        return PASS;
                    }
                }
                else
                {
                    ADEN = 0;
                    return FAIL;
                }
            }
        }
    }
    else
    {
        while (1)
        {
            if ((OSADJCR & 0x3f) == 0x3f)
            {
                ADEN = 0;
                return FAIL;
            }
            else
            {
                OSADJCR ++;
                ADEOC = 0;
                while (!ADEOC);
                if ((ADRH == 0) && ((ADRL & 0x0F) == 0))//ǷΪ0
                {
                    ADEN = 0;
                    return PASS;
                }
            }
        }
    }
}

/************************************************
;  *    @Function Name       : ADC_Init
;  *    @Description         : ADCʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/
void ADC_Init(void)
{
    OEP1 &= DEF_CLR_BIT5;                        //P15Ϊ
    P1ADCR |= DEF_SET_BIT5;                      //ʹP15ģ⹦
    ADCR0 = 0xEF;                                //ʹADC16Ƶ
    ADCR1 = 0x30;                                //12λH8L4ڲ2V
}

/************************************************
;  *    @Function Name       : ADC_Get_Value_Average
;  *    @Description         : ת
;  *    @IN_Parameter        : ͨ
;  *    @Return parameter    : ADCֵ
;  ***********************************************/
uint ADC_Get_Value_Average(u8 CHX)
{
    g_temp_value = 0;
    g_channel = 0;
    g_tmpbuff = 0;
    g_adcmax = 0;
    g_adcmin = 0xffff;
    ADCR0 = (ADCR0 & 0xF0) | CHX ;         // ADC ʹ  ADתͨ  ͨ  CHX
    delay(300);                                  //лͨʱ200uS
    for (g_channel = 0; g_channel < 20; g_channel ++)
    {
        ADEOC = 0;
        while (!ADEOC);                         //ȴת
        g_temp_value = ADRH;
        g_temp_value = g_temp_value << 4 | (ADRL & 0x0f);
        if (g_channel < 2)
            continue;                            //ǰβ
        if (g_temp_value > g_adcmax)
            g_adcmax = g_temp_value;             //
        if (g_temp_value < g_adcmin)
            g_adcmin = g_temp_value;             //С
        g_tmpbuff += g_temp_value;
    }
    g_tmpbuff -= g_adcmax;                       //ȥһ
    g_tmpbuff -= g_adcmin;                       //ȥһС
    g_temp_value = (g_tmpbuff >> 4);             //16ȡƽֵ
    return g_temp_value;
}

/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER1_INT_Init();
    TIMER0_INT_Init();
    while (ADC_Zero_ADJ());                      //demoʾ,У׼ʧһֱУ׼ûѡǷУ׼
    ADC_Init();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if (FLAG_TIMER1_5000MS)
        {
            FLAG_TIMER1_5000MS = 0;
            g_adc_value0_temp = ADC_Get_Value_Average(8);
            UART_TX_Value(0x5a);
            UART_TX_Num = g_adc_value0_temp >> 8;
            UART_TX_Value(UART_TX_Num);
            UART_TX_Num = g_adc_value0_temp & 0xff;
            UART_TX_Value(UART_TX_Num);
            UART_TX_Value(0xa5);
        }
    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _PFLAG
    movra _statusbuf
    __endasm;

    if((T0IF)&&(T0IE))
    {
        T0IF = 0;
        if(TX_Bit_num == 0)     //ʼλ
        {
            TX = 0;
            TX_Bit_num++;       //λһ
        }
        else if(TX_Bit_num < 9) //λ
        {
            if(UART_TX_Num&0x01)
            {
                TX = 1;
            }
            else TX = 0;
            TX_Bit_num++;       //λһ
            UART_TX_Num >>= 1;  //λȴһη
        }
        else if(TX_Bit_num < 10)// ֹλ
        {
            TX = 1;
            TX_Bit_num++;       //Ƴ
        }
        else
        {
            Uart_TX_flag = 0;
            TX_Bit_num = 0;     //λ
            T0IE = 0;
        }
    }
    if (T1IF & T1IE)
    {
        T1IF = 0;
        timer1_cnt1++;
        if (timer1_cnt1 >= 5000)      //5s
        {
            timer1_cnt1 = 0;
            FLAG_TIMER1_5000MS = 1;
        }
    }
    __asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
    __endasm;
}

/**************************** end of file *********************************************/
