/******************************************************************************
;  *    @MCU                 : MC32F7062B
;  *    @             : 2024.11.15
;  *    @˾/            : SinoMCU-FAE
;  *    @΢           : http://www.sinomcu.com/
;  *    @Ȩ                 : 2024 SINOMCU ȨС
;  *
;  *------------------------------- ժҪ ----------------------------------
;  *                                궨
;******************************************************************************/
#ifndef USER
#define USER

#include "MC32F7062B.h"

#define u8 unsigned char
#define u16 unsigned int
#define u32 unsigned long int
#define uint8_t  unsigned char
#define uint16_t unsigned int
#define uint32_t unsigned long int

#define DEF_SET_BIT0                0x01
#define DEF_SET_BIT1                0x02
#define DEF_SET_BIT2                0x04
#define DEF_SET_BIT3                0x08
#define DEF_SET_BIT4                0x10
#define DEF_SET_BIT5                0x20
#define DEF_SET_BIT6                0x40
#define DEF_SET_BIT7                0x80

#define DEF_CLR_BIT0                0xFE
#define DEF_CLR_BIT1                0xFD
#define DEF_CLR_BIT2                0xFB
#define DEF_CLR_BIT3                0xF7
#define DEF_CLR_BIT4                0xEF
#define DEF_CLR_BIT5                0xDF
#define DEF_CLR_BIT6                0xBF
#define DEF_CLR_BIT7                0x7F

#define ENABLE                      1
#define DISABLE                     0

#define FAIL                        1
#define PASS                        0

#define ADCKS_DIV2                  0x00
#define ADCKS_DIV4                  0x10
#define ADCKS_DIV8                  0x20
#define ADCKS_DIV16                 0x30

#define ADVRS_2V                    0x30
#define ADVRS_VDD                   0x00

#define ADSPS_15CLK                 0x00
#define ADSPS_8CLK                  0x01
#define ADSPS_4CLK                  0x02
#define ADSPS_2CLK                  0x03

#define TXD                         P04D

//=========Field Protection Variables==========
u8 abuf;
u8 statusbuf;

//===============Global Variable===============
uint8_t  g_timer0_cnt;
uint16_t g_adc_value_temp;
uint8_t  g_uart_send_time;
uint16_t g_uart_byte_data;

//===============Global Function===============
void DELAY(uint16_t num);
void INIT_RAM(void);
void INIT_GPIO(void);
void ADC_POWER_ON_STABILITY(void);
uint8_t ADC_ZERO_ADJ(void);
void INIT_ADC(void);
void ADC_CONFIG(u8 ADVRS,u8 ADCKS,u8 ADSPS);
void ADC_START(void);
uint ADC_GET_VALUE_AVERAGE(uint8_t CHX);
uint ADC_GET_VALUE_ONCE(uint8_t CHX);
void UART_SEND_DW_BYTE(uint send_dwdata);
void UART_SEND_BYTE(uchar send_data);
void UART_SEND_BITS(void);
void INIT_TIMER0(void);
void INIT_TIMER3(void);
void SYS_INIT(void);

//================Define  Flag=================
typedef union {
       unsigned char byte;
       struct
       {
              u8 BIT0 : 1;
              u8 BIT1 : 1;
              u8 BIT2 : 1;
              u8 BIT3 : 1;
              u8 BIT4 : 1;
              u8 BIT5 : 1;
              u8 BIT6 : 1;
              u8 BIT7 : 1;
       } BITS;
}BIT_FLAG;
volatile BIT_FLAG FLAG1;

#define   FLAG_TIMER0_1S    FLAG1.BITS.BIT0      // 1S־λ
#define   FLAG_UART_STOP    FLAG1.BITS.BIT1      // UARTֹͣ־λ

#endif

/**************************** end of file *******************************/