/******************************************************************************
;  *    @MCU                 : MC32F7062B
;  *    @             : 2024.11.15
;  *    @˾/            : SinoMCU-FAE
;  *    @΢           : http://www.sinomcu.com/
;  *    @Ȩ                 : 2024 SINOMCU ȨС
;  *
;  *------------------------------- ժҪ ----------------------------------
;  *                                Ƚ 
;  *                        ˣⲿCMPN3 P13(1/2)
;  *                        ˣڲ0.45VDD
;  *                        16FCPUشCMPж
;  *                        CMPN00.9VDDCMPO0֮1,ҴжP00D״̬ת
;  *                        ûѡǷ CMP_ADJ ʧѹУ
;  *                        ͨѶ P10(PDT0)P11(PCK0)
;******************************************************************************/
#include "user.h"

#define CMP_ADJ_ON                  1  // CMPʧѹУ
// #define CMP_ADJ_ON                  0  // رCMPʧѹУ

// #define CMPO_OUT                    1  // CMPOIO
#define CMPO_OUT                    0  // CMPO

/************************************************
;  *    @Function Name       : DELAY
;  *    @Description         : ȷʱ
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void DELAY(uint16_t num)
{
    uint16_t i;
    for (i = 0; i < num; i++)
    {
        Nop();
    }
}

/************************************************
;  *    @Function Name       : INIT_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}

/************************************************
;  *    @Function Name       : INIT_GPIO
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_GPIO(void)
{
//  IOλ
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;
//  IO          1:  0:
    OEP0 = 0xff;
    OEP1 = 0xff;
    OEP2 = 0xff;
//  IO      1:  0:ر
    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;
//  IO      1:  0:ر
    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
//  IOģѡ      1:ģ  0:
    P0ADCR = 0x00;
    P1ADCR = 0x00;
    P2ADCR = 0x00;
}

#if CMP_ADJ_ON
/************************************************
;  *    @Function Name       : CMP_ADJ
;  *    @Description         : CMP У׼
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 0 У׼ɹ  1У׼ʧ
;  ***********************************************/ 
uint8_t CMP_ADJ(void)
{
    CMPCR0 = DEF_SET_BIT7|DEF_SET_BIT6|DEF_SET_BIT5|DEF_SET_BIT4|DEF_SET_BIT2;
    CMPCR1 = DEF_SET_BIT4|DEF_SET_BIT3|DEF_SET_BIT2;
    CMPCLRE = 1;                 // ʹCMPģʽ
    CMPCLRS = 1;                 // ο
    CMPCLR &= 0xc0;              // õ6λ=0
    DELAY(1000);                 // ʱ > 100US
    CMPOF_FLAG = CMPOF;          // ȡֵ
    while(1)
    {
        CMPCLR++;
        DELAY(1000);
        if(CMPOF != CMPOF_FLAG)  // жǷУ׼
    break;                       // У׼
        if((CMPCLR<<2)== 0xfc)   // жϵ6λֵ
    return FAIL;                 // У׼ʧ
    }
    if((CMPCLR&0X20)!= 0X20)
        CMPCLR -= 1;
    return PASS;                 // У׼ɹ
}
#endif

/************************************************
;  *    @Function Name       : INIT_CMP
;  *    @Description         :  CMP ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_CMP(void)
{
    P13OE = 0;                   // P13Ϊ(CMPN0)
    P13DC = 1;
#if CMP_ADJ_ON
    while(CMP_ADJ());            // ȴCMPУ׼
    CMPCLRE = 0;                 // У׼رCMPģʽ
#endif

#if CMPO_OUT
    CMPCR0 = 0x64;               // 16FCPUCMPIO(CMPO)ش
#else
    CMPCR0 = 0x60;               // 16FCPUCMPش
#endif

    CMPCR1 = 0x24;               // CMP0.45VDDCMPN0
    CMPNDIV = 1;                 // 1/2ѹ
    CMPEN = 1;                   // CMPģ
    CMPIF = 0;                   // CMPжϱ־λ
    CMPIE = 1;                   // CMPж
}

/************************************************
;  *    @Function Name       : INIT_SYS
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_SYS(void)
{
    GIE = 0;
    INIT_RAM();
    INIT_GPIO();
    INIT_CMP();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void main(void)
{
    INIT_SYS();
    while (1)
    {
        ClrWdt();
    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϷ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((CMPIF) && (CMPIE)) // CMPж
    {
        P00D = !P00D;
        CMPIF = 0;
    }

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
