/******************************************************************************
;  *    @MCU                 : MC32F7062B
;  *    @             : 2024.10.08
;  *    @˾/            : SinoMCU-FAE
;  *    @΢           : http://www.sinomcu.com/
;  *    @Ȩ                 : 2024 SINOMCU ȨС
;  *
;  *------------------------------- ժҪ ----------------------------------
;  *                                LVD  жϡжϣ
;  *                        LVD趨ֵ2.6V
;  *                        жϣVDDС2.6VP00Dߣ֮P00D
;  *                        жϣVDDС2.6VLVDжϣP00D״̬ȡ
;  *                        P01DΪߴоƬڹ
;  *                        ͨѶ P10(PDT0)P11(PCK0)
;******************************************************************************/
#include "user.h"

//#define LVD_IE           1  // LVDж
#define LVD_IE           0  // LVDж
/************************************************
;  *    @Function Name       : INIT_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}

/************************************************
;  *    @Function Name       : INIT_GPIO
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_GPIO(void)
{
//  IOλ
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;
//  IO          1:  0:
    OEP0 = 0xff;
    OEP1 = 0xff;
    OEP2 = 0xff;
//  IO      1:  0:ر
    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;
//  IO      1:  0:ر
    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
//  IOģѡ      1:ģ  0:
    P0ADCR = 0x00;
    P1ADCR = 0x00;
    P2ADCR = 0x00;

   	P01D = 1;  // ϵͳĬΪ
}

/************************************************
;  *    @Function Name       : INIT_LVD
;  *    @Description         : LVDʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_LVD(void)
{
    LVDCR = 0x98;  // LVDLVDֵ 2.6V
}

/************************************************
;  *    @Function Name       : INIT_SYS
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_SYS(void)
{
    GIE = 0;
    INIT_RAM();
    INIT_GPIO();
    INIT_LVD();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void main(void)
{
    INIT_SYS();
    #if (LVD_IE)
        LVDIF = 0;
        LVDIE = 1;  // LVDж
    #endif
    while (1)
    {
        ClrWdt();
    #if (!LVD_IE)
        if(LVDF)    // VDDС趨ֵ 2.6V
            P00D=1;
        else
            P00D=0;
    #endif
    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϷ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((LVDIF) && (LVDIE))  // VDDС趨ֵ 2.6V
    {
        P00D = !P00D;
        LVDIF = 0;
    }

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
