/******************************************************************************
;  *    @MCU                 : MC32F7062B
;  *    @             : 2024.11.14
;  *    @˾/            : SinoMCU-FAE
;  *    @΢           : http://www.sinomcu.com/
;  *    @Ȩ                 : 2024 SINOMCU ȨС
;  *
;  *------------------------------- ժҪ ----------------------------------
;  *                                T1벶 
;  *                        ţP20׽ظ1
;  *                        ⵽ʼʱT1CNTʼ
;  *                        ⵽ֹʱT1CNTֹͣ
;  *                        ͨѶ P10(PDT0)P11(PCK0)
;******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : INIT_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}

/************************************************
;  *    @Function Name       : INIT_GPIO
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_GPIO(void)
{
//  IOλ
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;
//  IO          1:  0:
    OEP0 = 0xff;
    OEP1 = 0xff;
    OEP2 = 0xff;
//  IO      1:  0:ر
    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;
//  IO      1:  0:ر
    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
//  IOģѡ      1:ģ  0:
    P0ADCR = 0x00;
    P1ADCR = 0x00;
    P2ADCR = 0x00;

    P20OE = 0;   // P20Ϊ
    P20PD = 1;
}

/************************************************
;  *    @Function Name       : INIT_TIMER1
;  *    @Description         : TIMER1ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_TIMER1(void)
{
    T1CR0 = DEF_SET_BIT6 | DEF_SET_BIT2 | DEF_SET_BIT0;  // ģʽ,FCPU 8M,32Ƶ,500uS
   	T1CR1 = DEF_SET_BIT7 | DEF_SET_BIT2;                 // ׽ʽINT0,ش,½ֹ,׽1
    T1CNTH = 0;
    T1CNTL = 125 - 1;
    T1LOADH = 0;
    T1LOADL = 125 - 1;
    T1EN = 1;
    T1IE = 1;                             // T1ж
   	T1CIE = 1;                            // T1׽ж
}

/************************************************
;  *    @Function Name       : INIT_SYS
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_SYS(void)
{
    GIE = 0;
    INIT_RAM();
    INIT_GPIO();
    INIT_TIMER1();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void main(void)
{
    INIT_SYS();
    T1CEOC = 0;                 // ʼ
    while(!T1CEOC) {ClrWdt();}  // ȴ
    while (1)
    {
   	   	ClrWdt();
    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((T1IF) && (T1IE))  // עȴT1ڣжϣأȻ¼
    {
        P00D = !P00D;
        g_timer1_count++;  // ¼ܺȡ
        T1IF = 0;
    }
    if ((T1CIF) && (T1CIE))
    {
        T1CIF = 0;
    }

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
