/******************************************************************************
;  *    @MCU                 : MC32F7062B
;  *    @             : 2024.11.13
;  *    @˾/            : SinoMCU-FAE
;  *    @΢           : http://www.sinomcu.com/
;  *    @Ȩ                 : 2024 SINOMCU ȨС
;  *
;  *------------------------------- ժҪ ----------------------------------
;  *                                ʱ
;  *                        T0   P00 100uSת
;  *                        T1   P01 500uSת
;  *                        T2   P02   1mSת
;  *                        T3   P03   4MSת
;  *                        ͨѶ P10(PDT0)P11(PCK0)
;******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : INIT_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}

/************************************************
;  *    @Function Name       : INIT_GPIO
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_GPIO(void)
{
//  IOλ
    IOP0 = 0;
    IOP1 = 0;
    IOP2 = 0;
//  IO          1:  0:
    OEP0 = 0xff;
    OEP1 = 0xff;
    OEP2 = 0xff;
//  IO      1:  0:ر
    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;
//  IO      1:  0:ر
    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
//  IOģѡ      1:ģ  0:
    P0ADCR = 0x00;
    P1ADCR = 0x00;
    P2ADCR = 0x00;
}

/************************************************
;  *    @Function Name       : INIT_TIMER0
;  *    @Description         : TIMER0ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_TIMER0(void)
{
    T0CR = DEF_SET_BIT1 | DEF_SET_BIT0;  // FCPU 8M,8Ƶ,100uS
    T0CNT = 100 -1;
    T0LOAD = 100 -1;
    T0EN = 1;
    T0IE = 1;
}

/************************************************
;  *    @Function Name       : INIT_TIMER1
;  *    @Description         : TIMER1ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_TIMER1(void)
{
    T1CR0 = DEF_SET_BIT2 | DEF_SET_BIT0;  //ʱģʽ,FCPU 8M,32Ƶ,500uS
    T1CNTH = 0;
    T1CNTL = 125 - 1;
    T1LOADH = 0;
    T1LOADL = 125 - 1;
    T1EN = 1;
    T1IE = 1;
}

/************************************************
;  *    @Function Name       : INIT_TIMER2
;  *    @Description         : TIMER2ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_TIMER2(void)
{
    T2CR = DEF_SET_BIT2 | DEF_SET_BIT1;  // FCPU 8M,64Ƶ,1mS
    T2CNT = 125 - 1;
    T2LOAD = 125 - 1;
    T2EN = 1;
    T2IE = 1;
}

/************************************************
;  *    @Function Name       : INIT_TIMER3
;  *    @Description         : TIMER3ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_TIMER3(void)
{
    T3CR = DEF_SET_BIT0 | DEF_SET_BIT1 | DEF_SET_BIT2;  // FCPU 8M,128Ƶ,4MS
    T3CNT = 250 - 1;
    T3LOAD = 250 - 1;
    T3EN = 1;
    T3IE = 1;
}

/************************************************
;  *    @Function Name       : INIT_SYS
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_SYS(void)
{
    GIE = 0;
    INIT_RAM();
    INIT_GPIO();
    INIT_TIMER0();
    INIT_TIMER1();
    INIT_TIMER2();
    INIT_TIMER3();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void main(void)
{
    INIT_SYS();
    while (1)
    {
        ClrWdt();
    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if ((T0IF) && (T0IE))
    {
        P00D = !P00D;
        T0IF = 0;
    }
    if ((T1IF) && (T1IE))
    {
        P01D = !P01D;
        T1IF = 0;
    }
    if ((T2IF) && (T2IE))
    {
        P02D = !P02D;
        T2IF = 0;
    }
    if ((T3IF) && (T3IE))
    {
        P03D = !P03D;
        T3IF = 0;
    }

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
