/******************************************************************************
;  *    @MCU                 : MC32F7062B
;  *    @             : 2024.11.15
;  *    @˾/            : SinoMCU-FAE
;  *    @΢           : http://www.sinomcu.com/
;  *    @Ȩ                 : 2024 SINOMCU ȨС
;  *
;  *------------------------------- ժҪ ----------------------------------
;  *                                ADC 
;  *                        ϵȴADȶУ׼(ɼСʱ鿪)
;  *                        ADCɼ P20D(AN0)ڲVDDͨ(1/4)
;  *                        ɼ1SɼģUART(TX:P04D  :9600)
;  *                        ͨѶ P10(PDT0)P11(PCK0)
;******************************************************************************/
#include "user.h"

#define  ADC_ZERO_ADJ_ON                   0 // رADCУ׼
// #define  ADC_ZERO_ADJ_ON                   1 // ADCУ׼ɼСʱ鿪

/************************************************
;  *    @Function Name       : DELAY
;  *    @Description         : ȷʱ
;  *    @IN_Parameter        : ʱʱ
;  *    @Return parameter    : 
;  ***********************************************/ 
void DELAY(uint16_t num)
{
    uint16_t i;
    for (i = 0; i < num; i++)
    {
        Nop();
    }
}

/************************************************
;  *    @Function Name       : INIT_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0;
    }
    FSR0 = 0xFF;
    INDF0 = 0;
}

/************************************************
;  *    @Function Name       : INIT_GPIO
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_GPIO(void)
{
//  IOλ
    IOP0 = 0x10;  // TXD ĬΪ
    IOP1 = 0;
    IOP2 = 0;
//  IO          1:  0:
    OEP0 = 0xff;
    OEP1 = 0xff;
    OEP2 = 0xff;
//  IO      1:  0:ر
    PUP0 = 0x00;
    PUP1 = 0x00;
    PUP2 = 0x00;
//  IO      1:  0:ر
    PDP0 = 0x00;
    PDP1 = 0x00;
    PDP2 = 0x00;
//  IOģѡ      1:ģ  0:
    P0ADCR = 0x00;
    P1ADCR = 0x00;
    P2ADCR = 0x00;

    P20OE = 0;  // P20Ϊ
    P20DC = 1;  // P20Ϊģ
}

/************************************************
;  *    @Function Name       : ADC_POWER_ON_STABILITY
;  *    @Description         : ϵȶ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void ADC_POWER_ON_STABILITY(void)
{
    uint8_t cnt;
    ADCR0 = 0xfe;   // ʹADC16ƵVDD/4ͨ
    ADCR1 = 0x00;   // 12λH8L4ڲVDD15ADCLK
    ADC_START();
    cnt = 0;
    while (!(((ADRH >> 2) == 0x10) || ((ADRH >> 2) == 0x0F)))
    {
        ADC_START();
        cnt++;
        if (cnt >= 200)
            return; // ûӷֵ,ʾ
    }
}

/************************************************
;  *    @Function Name       : ADC_ZERO_ADJ
;  *    @Description         : ADC У׼
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 0 У׼ɹ  1У׼ʧ
;  ***********************************************/ 
#if  ADC_ZERO_ADJ_ON
uint8_t ADC_ZERO_ADJ(void)
{
    ADCR0 = 0xff;           // ʹADC16ƵGNDͨ
    ADCR1 = 0x30;           // 12λH8L4ڲ2V15ADCLK
    OSADJCR = DEF_SET_BIT7; // ʹУ׼޵
    ADC_START();
    if ((ADRH == 0) && ((ADRL & 0x0F) == 0))     // ǷΪ0
    {
        OSADJTD = 1;        // ޵
        OSADJCR |= 0x3F;
        ADC_START();
        if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) // ǷΪ0
        {
            ADEN = 0;
            return PASS;
        }
        else
        {
            while (1)
            {
                if (OSADJCR & 0x3f)
                {
                    OSADJCR--;
                    ADC_START();
                    if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) // ǷΪ0
                    {
                        ADEN = 0;
                        return PASS;
                    }
                }
                else
                {
                    ADEN = 0;
                    return FAIL;
                }
            }
        }
    }
    else
    {
        while (1)
        {
            if ((OSADJCR & 0x3f) == 0x3f)
            {
                ADEN = 0;
                return FAIL;
            }
            else
            {
                OSADJCR++;
                ADC_START();
                if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) // ǷΪ0
                {
                    ADEN = 0;
                    return PASS;
                }
            }
        }
    }
}
#endif

/************************************************
;  *    @Function Name       : INIT_ADC
;  *    @Description         : ADCʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_ADC(void)
{
    ADC_POWER_ON_STABILITY();
    #if  ADC_ZERO_ADJ_ON
    while (ADC_ZERO_ADJ());
    #endif
    ADC_CONFIG(ADVRS_2V,ADCKS_DIV8,ADSPS_8CLK);  // 2V1M, 8CLK
    ADEN = 1;   // ADC ʹ
    DELAY(40);  // ADC ʹʱ40uS
}

/************************************************
;  *    @Function Name       : ADC_CONFIG
;  *    @Description         : ADC 
;  *    @IN_Parameter        : οѹ תʱ 
;  *    @Return parameter    : 
;  ***********************************************/ 
void ADC_CONFIG(u8 ADVRS,u8 ADCKS,u8 ADSPS)
{
    ADCR0 = (ADCR0 & 0xCF) |ADCKS;         // תʱ
    ADCR1 = (ADCR1 & 0xCC) |ADVRS |ADSPS;  // ݸʽH8L4οѹʱ
}

/************************************************
;  *    @Function Name       : ADC_START
;  *    @Description         : ADCת
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void ADC_START(void)
{
    ADEOC = 0;      // ʼת
    while (!ADEOC); // ȴת
}

/************************************************
;  *    @Function Name       : ADC_GET_VALUE_AVERAGE
;  *    @Description         : ADC ˲
;  *    @IN_Parameter        : CHX   ɼͨ
;  *    @Return parameter    : temp_valueADCƽֵ
;  ***********************************************/ 
uint ADC_GET_VALUE_AVERAGE(uint8_t CHX)
{
    u16 temp_value = 0;
    u8 channel = 0;
    unsigned long int tmpbuff = 0;
    u16 ADCMAX = 0;
    u16 ADCMIN = 0xffff;

    ADCR0 = (ADCR0 & 0xF0) | CHX; // ADC ʹܣɼͨ
    for (channel = 0; channel < 20; channel++)
    {
   	   	ClrWdt();
        ADC_START();              // ȴת
        temp_value = ADRH;
        temp_value = temp_value << 4 | (ADRL & 0x0f);
        if (channel < 2)
            continue;             // ǰβ
        if (temp_value > ADCMAX)
            ADCMAX = temp_value;  // ɸѡ
        if (temp_value < ADCMIN)
            ADCMIN = temp_value;  // ɸѡС
        tmpbuff += temp_value;
    }
    tmpbuff -= ADCMAX;            // ȥֵ
    tmpbuff -= ADCMIN;            // ȥСֵ
    temp_value = (tmpbuff >> 4);  // 16ȡƽֵ
    return temp_value;
}

/************************************************
;  *    @Function Name       : ADC_GET_VALUE_ONCE
;  *    @Description         : ɼ1AD
;  *    @IN_Parameter        : ADֵ
;  *    @Return parameter    : 
;  ***********************************************/ 
uint ADC_GET_VALUE_ONCE(uint8_t CHX)
{
    u16 temp_value = 0;
    ADCR0 = (ADCR0 & 0xF0) | CHX; // ADC ʹܣɼͨ
    ADC_START();                  // ȴת
    temp_value = ADRH;
    temp_value = temp_value << 4 | (ADRL & 0x0f);
    return temp_value;
}

/************************************************
;  *    @Function Name       : UART_SEND_DW_BYTE
;  *    @Description         : UART
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void UART_SEND_DW_BYTE(uint send_dwdata)
{
    UART_SEND_BYTE(send_dwdata >> 4);
    UART_SEND_BYTE(send_dwdata & 0x00F);
}

/************************************************
;  *    @Function Name       : UART_SEND_BYTE
;  *    @Description         : ݷ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void UART_SEND_BYTE(uchar send_data)
{
    FLAG_UART_STOP = 1;
    g_uart_byte_data = send_data;
    T3IE = 0;
    T3IF = 0;
    T3EN = 0;
    T3CNT = 104 - 1;
    T3LOAD = 104 - 1; // 104uS
    T3EN = 1;
    T3IE = 1;
    T3IF = 0;
    while (FLAG_UART_STOP) {
        ClrWdt();
    }
}

/************************************************
;  *    @Function Name       : UART_SEND_BITS
;  *    @Description         : bit
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void UART_SEND_BITS(void)
{
    if (g_uart_send_time == 0)         // ʼλ
    {
        TXD = 0;
        g_uart_send_time++;
    } else if (g_uart_send_time < 9) {
        if (g_uart_byte_data & 0x01)
            TXD = 1;                   // ͸
        else
            TXD = 0;                   // ͵

        g_uart_byte_data >>= 1;        // λȷ
        g_uart_send_time++;
    } else if (g_uart_send_time < 10)  // ֹͣλ
    {
        TXD = 1;
        g_uart_send_time++;
    } else {
        g_uart_send_time = 0;
        FLAG_UART_STOP = 0;
        T3IE = 0;                      // رж
        T3EN = 0;
    }
    T3IF = 0;
}

/************************************************
;  *    @Function Name       : INIT_TIMER0
;  *    @Description         : TIMER0 ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_TIMER0(void)
{
    T0CR = DEF_SET_BIT2 | DEF_SET_BIT1 | DEF_SET_BIT0;  // FCPU 8M,128Ƶ,4MS
    T0CNT =  250 - 1;
    T0LOAD = 250 - 1;
    T0EN = 1;
    T0IF = 0;
    T0IE = 1;
}

/************************************************
;  *    @Function Name       : INIT_TIMER3
;  *    @Description         : TIMER3 ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void INIT_TIMER3(void)
{
    T3CR = DEF_SET_BIT1 | DEF_SET_BIT0;                // FCPU 8M,8Ƶ,104uS
    T3CNT = 104 - 1;
    T3LOAD = 104 - 1;
}

/************************************************
;  *    @Function Name       : SYS_INIT
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void SYS_INIT(void)
{
    GIE = 0;
    INIT_RAM();
    INIT_GPIO();
    INIT_ADC();
    INIT_TIMER0();
   	INIT_TIMER3();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void main(void)
{
    SYS_INIT();
    while (1)
    {
   	   	ClrWdt();
        if(FLAG_TIMER0_1S) {
            FLAG_TIMER0_1S = 0;
            UART_SEND_BYTE(0x5A);

            ADC_CONFIG(ADVRS_2V,ADCKS_DIV8,ADSPS_8CLK);   // ADC ڲ2V1M, 8CLK
            g_adc_value_temp = ADC_GET_VALUE_AVERAGE(14); // βɼƽ
            UART_SEND_DW_BYTE(g_adc_value_temp);

            ADC_CONFIG(ADVRS_VDD,ADCKS_DIV8,ADSPS_4CLK);  // ADC VDD1M, 4CLK
            g_adc_value_temp = ADC_GET_VALUE_ONCE(0);     // βɼ
            UART_SEND_DW_BYTE(g_adc_value_temp);

            UART_SEND_BYTE(0xA5);
        }
    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϷ
;  *    @IN_Parameter        : 
;  *    @Return parameter    : 
;  ***********************************************/ 
void int_isr(void) __interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
    if (T0IE & T0IF)
    {
        T0IF = 0;
        if(++g_timer0_cnt >= 250) {
            g_timer0_cnt = 0;
            FLAG_TIMER0_1S = 1;
        }
    }
    if (T3IE & T3IF)
    {
        UART_SEND_BITS();
    }
__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
